/*
 * Decompiled with CFR 0.152.
 */
package us.Myles.ItemRain;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import us.Myles.ItemRain.RainListener;

public class ItemRain
extends JavaPlugin {
    public static ItemRain instance;
    public Object lock = new Object();
    public ArrayList<Material> ITEMS = new ArrayList();
    private ArrayList<World> WORLDS = new ArrayList();
    public boolean useWorldList = false;
    public List<String> worldList = null;
    public int tickLength = 20;
    public int dropRadius = 10;
    public double normalChance = 0.5;
    public double thunderChance = 0.5;

    public void onEnable() {
        instance = this;
        this.setupConfig();
        this.getServer().getPluginManager().registerEvents((Listener)new RainListener(), (Plugin)this);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)instance, new Runnable(){

            @Override
            public void run() {
                instance.randomizer();
            }
        }, (long)this.tickLength, (long)this.tickLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWorld(World w) {
        Object object = this.lock;
        synchronized (object) {
            this.WORLDS.add(w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWorld(World w) {
        Object object = this.lock;
        synchronized (object) {
            this.WORLDS.remove(w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<World> getWorlds() {
        Object object = this.lock;
        synchronized (object) {
            return this.WORLDS;
        }
    }

    private void setupConfig() {
        String[] data;
        this.saveDefaultConfig();
        this.useWorldList = this.getConfig().getBoolean("use-world-list", false);
        this.worldList = this.getConfig().getStringList("worlds");
        if (this.getConfig().getBoolean("use-item-list", false)) {
            for (Object i : this.getConfig().getList("items")) {
                if (i instanceof Integer) {
                    this.ITEMS.add(Material.getMaterial((int)((Integer)i)));
                    continue;
                }
                Material[] materialArray = Material.values();
                int n = materialArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Material m = materialArray[n2];
                    if (m.name().equalsIgnoreCase((String)i) || m.name().replace("_", "").equalsIgnoreCase((String)i)) {
                        this.ITEMS.add(m);
                    }
                    ++n2;
                }
            }
        } else {
            Material[] materialArray = Material.values();
            int n = materialArray.length;
            int n3 = 0;
            while (n3 < n) {
                Material m = materialArray[n3];
                if (!m.isBlock()) {
                    this.ITEMS.add(m);
                }
                ++n3;
            }
        }
        this.tickLength = this.getConfig().getInt("tick-length", 20);
        this.dropRadius = this.getConfig().getInt("drop-radius", 10);
        if (this.getConfig().isDouble("normal-chance")) {
            this.normalChance = this.getConfig().getDouble("normal-chance", 0.5);
        } else if (this.getConfig().getString("normal-chance", "50%").contains("%")) {
            this.normalChance = Double.parseDouble(this.getConfig().getString("normal-chance", "50%").replace("%", "")) / 100.0;
        } else if (this.getConfig().getString("normal-chance", "50%").contains("/")) {
            data = this.getConfig().getString("normal-chance", "50%").split("/");
            if (data.length != 2) {
                System.out.println("[ItemRain] Error: Diving sign in wrong place!");
            } else {
                this.normalChance = Double.parseDouble(data[0]) / Double.parseDouble(data[1]);
            }
        } else {
            this.normalChance = Double.parseDouble(this.getConfig().getString("normal-chance", "50%"));
        }
        if (this.getConfig().isDouble("thunder-chance")) {
            this.thunderChance = this.getConfig().getDouble("thunder-chance", 0.5);
        } else if (this.getConfig().getString("thunder-chance", "50%").contains("%")) {
            this.thunderChance = Double.parseDouble(this.getConfig().getString("thunder-chance", "50%").replace("%", "")) / 100.0;
        } else if (this.getConfig().getString("thunder-chance", "50%").contains("/")) {
            data = this.getConfig().getString("thunder-chance", "50%").split("/");
            if (data.length != 2) {
                System.out.println("[ItemRain] Error: Diving sign in wrong place!");
            } else {
                this.thunderChance = Double.parseDouble(data[0]) / Double.parseDouble(data[1]);
            }
        } else {
            this.thunderChance = Double.parseDouble(this.getConfig().getString("thunder-chance", "50%"));
        }
        System.out.println("[ItemRain] Chance of normal item drop: " + this.normalChance);
        System.out.println("[ItemRain] Chance of thunder item drop: " + this.thunderChance);
    }

    public boolean isInteger(String input) {
        try {
            Integer.parseInt(input);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isAllowed(String world_name) {
        return !this.useWorldList || this.worldList.contains(world_name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void randomizer() {
        Object object = this.lock;
        synchronized (object) {
            for (World w : this.getWorlds()) {
                if (!this.isAllowed(w.getName())) continue;
                for (Player p : w.getPlayers()) {
                    if (!((double)this.random() <= this.normalChance)) continue;
                    Location l = p.getLocation();
                    int x = this.dropRadius;
                    w.dropItemNaturally(l.add((double)(this.random(x) + 1) - Math.ceil(x / 2), 20.0, (double)(this.random(x) + 1) - Math.ceil(x / 2)), new ItemStack(this.randomMaterial()));
                }
            }
        }
    }

    public void onLightning(Location l) {
        if (!this.isAllowed(l.getWorld().getName())) {
            return;
        }
        if ((double)this.random() <= this.thunderChance) {
            int x = 5;
            l.getWorld().dropItemNaturally(l.add((double)(this.random(x) + 1) - Math.ceil(x / 2), 20.0, (double)(this.random(x) + 1) - Math.ceil(x / 2)), new ItemStack(this.randomMaterial()));
        }
    }

    public float random() {
        Random r = new Random();
        return r.nextFloat();
    }

    public int random(int x) {
        Random r = new Random();
        return r.nextInt(x);
    }

    public Material randomMaterial() {
        Random r = new Random();
        Material m = this.ITEMS.get(r.nextInt(this.ITEMS.size()));
        return m;
    }
}

