/*
 * Decompiled with CFR 0.152.
 */
package com.dibujaron.BetterPassives;

import com.dibujaron.BetterPassives.ChunkListener;
import com.dibujaron.BetterPassives.EntityListener;
import com.dibujaron.BetterPassives.PlayerListener;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BetterPassives
extends JavaPlugin {
    public List<EntityType> passiveEntityTypes = new ArrayList<EntityType>();
    public List<String> cowNames = new ArrayList<String>();
    public List<String> pigNames = new ArrayList<String>();
    public List<String> wolfNames = new ArrayList<String>();
    public List<String> chickenNames = new ArrayList<String>();
    public List<String> sheepNames = new ArrayList<String>();

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EntityListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChunkListener(this), (Plugin)this);
        this.saveDefaultConfig();
        this.passiveEntityTypes.add(EntityType.CHICKEN);
        this.passiveEntityTypes.add(EntityType.COW);
        this.passiveEntityTypes.add(EntityType.PIG);
        this.passiveEntityTypes.add(EntityType.SHEEP);
        this.passiveEntityTypes.add(EntityType.WOLF);
        this.cowNames = this.getConfig().getStringList("cowNames");
        this.sheepNames = this.getConfig().getStringList("sheepNames");
        this.wolfNames = this.getConfig().getStringList("pigNames");
        this.chickenNames = this.getConfig().getStringList("chickenNames");
        this.pigNames = this.getConfig().getStringList("pigNames");
    }

    public void setMetadata(Player player, String key, Object value) {
        player.setMetadata(key, (MetadataValue)new FixedMetadataValue((Plugin)this, value));
    }

    public Object getMetadata(Player player, String key) {
        List values = player.getMetadata(key);
        for (MetadataValue value : values) {
            if (!value.getOwningPlugin().getDescription().getName().equals(this.getDescription().getName())) continue;
            return value.value();
        }
        return null;
    }

    public ItemStack getTameItem(Entity entity) {
        EntityType type = entity.getType();
        if (type == EntityType.PIG) {
            return new ItemStack(Material.CARROT_ITEM);
        }
        if (type == EntityType.COW || type == EntityType.SHEEP) {
            return new ItemStack(Material.WHEAT);
        }
        if (type == EntityType.WOLF) {
            return new ItemStack(Material.BONE);
        }
        if (type == EntityType.CHICKEN) {
            return new ItemStack(Material.SEEDS);
        }
        return null;
    }

    public String getRandomName(Entity entity) {
        EntityType type = entity.getType();
        if (type == EntityType.PIG) {
            return this.pigNames.get((int)((double)this.pigNames.size() * Math.random()));
        }
        if (type == EntityType.COW) {
            return this.cowNames.get((int)((double)this.cowNames.size() * Math.random()));
        }
        if (type == EntityType.SHEEP) {
            return this.sheepNames.get((int)((double)this.sheepNames.size() * Math.random()));
        }
        if (type == EntityType.WOLF) {
            return this.wolfNames.get((int)((double)this.wolfNames.size() * Math.random()));
        }
        if (type == EntityType.CHICKEN) {
            return this.chickenNames.get((int)((double)this.chickenNames.size() * Math.random()));
        }
        return null;
    }

    public Block getRealHighestBlockAt(Location location) {
        Location location2 = location.getWorld().getHighestBlockAt(location).getLocation();
        Location location3 = new Location(location2.getWorld(), location2.getX(), location2.getY() - 1.0, location2.getZ());
        return location3.getBlock();
    }
}

