/*
 * Decompiled with CFR 0.152.
 */
package me.BlockCat.bukkitSQL.pool;

import java.util.Stack;
import me.BlockCat.bukkitSQL.pool.Pool;
import me.BlockCat.bukkitSQL.pool.PoolObjectFactory;

public class ObjectPool<Type>
implements Pool<Type> {
    private final Stack<Type> freeObjects = new Stack();
    private PoolObjectFactory<Type> factory;

    @Override
    public void recycle(Type data) {
        this.freeObjects.push(data);
    }

    @Override
    public Type get() {
        if (this.freeObjects.isEmpty()) {
            return this.factory.newObject();
        }
        return this.freeObjects.pop();
    }

    @Override
    public void setFactory(PoolObjectFactory<Type> factory) {
        this.factory = factory;
    }

    @Override
    public void reset() {
        this.freeObjects.clear();
    }

    @Override
    public String debug() {
        return "Current Pool Size: " + this.freeObjects.size();
    }
}

