/*
 * Decompiled with CFR 0.152.
 */
package net.makeitonthe.GemXp;

import java.util.LinkedList;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class XpContainer
extends ItemStack {
    public static int MAX_STORAGE = Short.MAX_VALUE;
    public static double MAX_TAX = 99.0;
    public static String DISPLAY_NAME_FORMAT = "\u00a7o\u00a7f";
    public static String LORE_FORMAT = "\u00a7r\u00a77";
    private static int itemId;
    private static int imbuedItemId;
    private static int maxExp;
    private static String itemName;
    private static String itemHint;
    private static double xpTax;
    private static int stackSize;
    private ItemStack itemStack;

    public XpContainer(ItemStack stack) {
        super(stack);
        this.itemStack = stack;
    }

    public static boolean isAnXpContainer(ItemStack stack) {
        int itemId = 0;
        boolean container = false;
        if (stack != null) {
            itemId = stack.getTypeId();
            container = itemId == XpContainer.getImbuedItemId() || itemId == XpContainer.getItemId();
        }
        return container;
    }

    public static boolean isAFilledXpContainer(ItemStack stack) {
        boolean container = false;
        if (stack != null) {
            container = stack.getTypeId() == XpContainer.getImbuedItemId() && stack.getDurability() > 0;
        }
        return container;
    }

    public boolean canContainXp() {
        return this.getTypeId() == XpContainer.getImbuedItemId();
    }

    public boolean canStoreXp() {
        return this.getTypeId() == XpContainer.getItemId();
    }

    public XpContainer clone() {
        return new XpContainer(new ItemStack(this.getItemStack()));
    }

    public int getAmount() {
        return this.getItemStack().getAmount();
    }

    public void setAmount(int i) {
        this.getItemStack().setAmount(i);
    }

    public int getStoredXp() {
        return this.getDurability();
    }

    public void setStoredXp(int xp) {
        if (xp > XpContainer.getmaxExp()) {
            xp = XpContainer.getmaxExp();
        }
        if (xp == 0) {
            this.resetContainer();
        } else {
            this.initContainer(xp);
        }
        this.setDurability((short)xp);
    }

    public static int getItemId() {
        return itemId;
    }

    public static int getImbuedItemId() {
        return imbuedItemId;
    }

    public static int getmaxExp() {
        return maxExp;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public static double getXpTax() {
        return xpTax;
    }

    public int getMaxStackSize() {
        int max = this.canContainXp() && this.getStoredXp() > 0 ? stackSize : this.getType().getMaxStackSize();
        return max;
    }

    protected static String getItemName() {
        return itemName;
    }

    protected static String getItemHint() {
        return itemHint;
    }

    protected static void setImbuedItemId(int imbuedItemId) {
        XpContainer.imbuedItemId = imbuedItemId;
    }

    protected static void setItemId(int itemId) {
        XpContainer.itemId = itemId;
    }

    protected static boolean setMaxExp(int maxExp) {
        boolean result = false;
        if (maxExp > MAX_STORAGE) {
            XpContainer.maxExp = MAX_STORAGE;
        } else {
            XpContainer.maxExp = maxExp;
            result = true;
        }
        return result;
    }

    protected static void setItemName(String itemName) {
        XpContainer.itemName = itemName;
    }

    protected static void setItemHint(String itemHint) {
        XpContainer.itemHint = itemHint;
    }

    protected static void setXpTax(double xpTax) {
        XpContainer.xpTax = xpTax;
    }

    protected static void setMaxStackSize(int maxStackSize) {
        stackSize = maxStackSize;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (this == obj) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        XpContainer other = (XpContainer)((Object)obj);
        if (other.canContainXp() == this.canContainXp() && other.canStoreXp() == this.canStoreXp() && other.getStoredXp() == this.getStoredXp()) {
            result = true;
        }
        return result;
    }

    private void initContainer(int xp) {
        ItemMeta itemMeta = this.getItemMeta();
        LinkedList<String> lores = itemMeta.getLore();
        String lore = String.valueOf(LORE_FORMAT) + XpContainer.getItemHint() + " " + xp + "xp";
        this.setTypeId(XpContainer.getImbuedItemId());
        itemMeta.setDisplayName(String.valueOf(DISPLAY_NAME_FORMAT) + XpContainer.getItemName());
        if (lores != null) {
            lores.add(lore);
        } else {
            lores = new LinkedList<String>();
            lores.add(lore);
        }
        itemMeta.setLore(lores);
        this.setItemMeta(itemMeta);
    }

    private void resetContainer() {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.setDisplayName(null);
        itemMeta.setLore(null);
        this.setItemMeta(itemMeta);
        this.setTypeId(XpContainer.getItemId());
    }
}

