/*
 * Decompiled with CFR 0.152.
 */
package net.makeitonthe.GemXp;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.makeitonthe.GemXp.GemInteractListener;
import net.makeitonthe.GemXp.XpContainer;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.java.JavaPlugin;

public class GemXp
extends JavaPlugin {
    private static final Logger LOGGER = Logger.getLogger("Minecraft");
    private static final String LOGGER_PREFIX = "[GemXP]";
    private static final int CONFIG_VERSION = 4;
    private List<String> messages;

    public void onEnable() {
        this.loadConfig();
        new GemInteractListener(this);
        this.logInfo("Plugin loading complete. Plugin enabled.");
    }

    public void onDisable() {
        this.logInfo("Plugin disabled.");
    }

    public void loadConfig() {
        if (this.getConfig().getInt("configversion", 0) < 4) {
            this.saveResource("config.yml", true);
            this.logInfo("New config file created, you should check if your configurations are correct!");
            this.reloadConfig();
        }
        if (!XpContainer.setMaxExp(this.getConfig().getInt("max_level"))) {
            this.log(Level.WARNING, "maxLevel exceeds possible limits! Please modify your config file.");
            this.logInfo("Setting maxLevel to " + XpContainer.MAX_STORAGE);
        }
        XpContainer.setItemId(this.getConfig().getInt("item_id"));
        String itemName = Material.getMaterial((int)XpContainer.getItemId()).toString();
        XpContainer.setItemName(this.getConfig().getString("item_name", itemName.toLowerCase()));
        XpContainer.setItemHint(this.getConfig().getString("hint", ""));
        XpContainer.setImbuedItemId(this.getConfig().getInt("filled_appearance", XpContainer.getItemId()));
        if (this.getConfig().contains("max_gem_stack_size")) {
            this.log(Level.WARNING, "Doesn't support custom stack size since 1.5...");
            XpContainer.setMaxStackSize(Material.getMaterial((int)XpContainer.getImbuedItemId()).getMaxStackSize());
        }
        if (this.getConfig().getDouble("xp_tax") > XpContainer.MAX_TAX) {
            XpContainer.setXpTax(this.getConfig().getDefaults().getDouble("xp_tax") / 100.0);
            this.log(Level.WARNING, "xp_tax exceeds possible limits! Please modify your config file.");
            this.logInfo("Setting xp_tax to " + this.getConfig().getDefaults().getDouble("xp_tax") + "%");
        } else {
            XpContainer.setXpTax(this.getConfig().getDouble("xp_tax") / 100.0);
        }
        ConfigurationSection msgSection = this.getConfig().getConfigurationSection("Messages");
        this.messages = new ArrayList<String>();
        if (msgSection != null) {
            MsgKeys[] msgKeysArray = MsgKeys.values();
            int n = msgKeysArray.length;
            int n2 = 0;
            while (n2 < n) {
                MsgKeys key = msgKeysArray[n2];
                this.messages.add(msgSection.getString(key.getKey(), null));
                ++n2;
            }
        }
    }

    public void logInfo(String msg) {
        this.log(Level.INFO, msg);
    }

    public void log(Level level, String msg) {
        LOGGER.log(level, String.format("%s %s", LOGGER_PREFIX, msg));
    }

    public String getMessage(MsgKeys key) {
        String msg = null;
        int i = 0;
        MsgKeys[] msgKeysArray = MsgKeys.values();
        int n = msgKeysArray.length;
        int n2 = 0;
        while (n2 < n) {
            MsgKeys k = msgKeysArray[n2];
            if (key == k && i < this.messages.size()) {
                msg = this.messages.get(i);
            }
            ++i;
            ++n2;
        }
        return msg;
    }

    public static enum MsgKeys {
        IMBUE_XP("filled_xp"),
        RESTORE_XP("restore_xp");

        private String key;

        private MsgKeys(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

