/*
 * Decompiled with CFR 0.152.
 */
package net.makeitonthe.GemXp;

import net.makeitonthe.GemXp.GemInventory;
import net.makeitonthe.GemXp.GemXp;
import net.makeitonthe.GemXp.XpContainer;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.GameMode;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class GemInteractListener
implements Listener {
    private static final ChatColor TEXT_COLOR = ChatColor.BLUE;
    private String imbueXpMsg;
    private String restoreXpMsg;
    private GemXp plugin;

    public GemInteractListener(GemXp plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.imbueXpMsg = plugin.getMessage(GemXp.MsgKeys.IMBUE_XP);
        this.restoreXpMsg = plugin.getMessage(GemXp.MsgKeys.RESTORE_XP);
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Action action = event.getAction();
        int xp = 0;
        double xpTaxed = 0.0;
        if (event.hasItem() && XpContainer.isAnXpContainer(event.getItem())) {
            XpContainer gem = new XpContainer(event.getItem());
            if (action == Action.LEFT_CLICK_AIR || action == Action.LEFT_CLICK_BLOCK) {
                Player player = event.getPlayer();
                int playerXp = this.getTotalExp(player);
                if (gem.canStoreXp() && gem.getStoredXp() == 0) {
                    if (playerXp > 0 || player.getGameMode() == GameMode.CREATIVE) {
                        if ((double)playerXp > (double)XpContainer.getmaxExp() + (double)XpContainer.getmaxExp() * XpContainer.getXpTax()) {
                            xp = XpContainer.getmaxExp();
                            xpTaxed = (double)xp * XpContainer.getXpTax();
                        } else {
                            xp = playerXp;
                            xpTaxed = (double)xp * XpContainer.getXpTax();
                            xp -= (int)xpTaxed;
                        }
                        if (player.getGameMode() == GameMode.CREATIVE) {
                            gem = this.storeAndStackXp(XpContainer.getmaxExp(), gem, player);
                        } else {
                            gem = this.storeAndStackXp(xp, gem, player);
                            this.removePlayerXp((int)((double)xp + xpTaxed), player);
                        }
                        this.sendInfo(this.imbueXpMsg, player, gem);
                        player.getWorld().playEffect(player.getEyeLocation(), Effect.ENDER_SIGNAL, 0);
                        player.playEffect(player.getEyeLocation(), Effect.EXTINGUISH, 0);
                    }
                } else if (gem.canContainXp() && gem.getStoredXp() > 0) {
                    xp = gem.getStoredXp();
                    this.storeAndStackXp(0, gem, player);
                    if (player.getGameMode() != GameMode.CREATIVE) {
                        player.giveExp(xp);
                    }
                    this.sendInfo(this.restoreXpMsg, player, gem);
                    player.playEffect(player.getEyeLocation(), Effect.GHAST_SHOOT, 0);
                    player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 2, 1));
                    player.getWorld().playEffect(player.getEyeLocation(), Effect.SMOKE, (Object)BlockFace.SELF);
                }
            } else if ((action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK) && gem.canContainXp() && gem.getStoredXp() > 0) {
                event.setUseItemInHand(Event.Result.DENY);
            }
        }
    }

    private String formatMsg(String msg, int xp, int playerXp) {
        if (msg == null) {
            return null;
        }
        String[] values = new String[]{XpContainer.getItemName().toLowerCase(), String.valueOf(xp), String.valueOf(playerXp)};
        return this.formatMsg(msg, values);
    }

    private String formatMsg(String msg, String[] values) {
        String[] keys = new String[]{"item_name", "xp", "player_xp"};
        if (msg != null) {
            int i = 0;
            while (i < keys.length && i < values.length) {
                msg = msg.replaceAll("\\$\\{" + keys[i] + "\\}", values[i]);
                ++i;
            }
        }
        return msg;
    }

    private void sendInfo(String msg, Player p, XpContainer i) {
        if (msg != null) {
            this.sendInfo(msg, TEXT_COLOR, p, i);
        }
    }

    private void sendInfo(String msg, ChatColor c, Player p, XpContainer i) {
        if (msg != null) {
            p.sendMessage(c + this.formatMsg(msg, i.getStoredXp(), p.getTotalExperience()));
        }
    }

    private void removePlayerXp(int xp, Player p) {
        int currentXp = this.getTotalExp(p);
        p.setTotalExperience(0);
        p.setExp(0.0f);
        p.setLevel(0);
        p.giveExp(currentXp - xp);
    }

    private XpContainer storeAndStackXp(int xp, XpContainer item, Player player) {
        PlayerInventory inv = player.getInventory();
        int slot = inv.firstEmpty();
        XpContainer newGem = new XpContainer(item.clone());
        newGem.setStoredXp(xp);
        ItemStack similarStack = GemInventory.findSimilarStack((Inventory)inv, newGem);
        if (item.getAmount() == 1 && similarStack == null) {
            inv.setItemInHand((ItemStack)newGem);
        } else {
            if (similarStack != null) {
                similarStack.setAmount(similarStack.getAmount() + 1);
            } else {
                newGem.setAmount(1);
                if (slot >= 0) {
                    inv.setItem(slot, (ItemStack)newGem);
                } else {
                    Item droppedItem = player.getWorld().dropItem(player.getEyeLocation().subtract(new Vector(0.0, 0.2, 0.0)), (ItemStack)newGem);
                    this.plugin.getServer().getPluginManager().callEvent((Event)new PlayerDropItemEvent(player, droppedItem));
                    Vector lookingVector = this.getLookingVector(player);
                    lookingVector.multiply(0.4);
                    droppedItem.setVelocity(lookingVector);
                }
            }
            if (item.getAmount() == 1) {
                inv.setItemInHand(null);
            } else {
                item.setAmount(item.getAmount() - 1);
            }
        }
        return newGem;
    }

    private Vector getLookingVector(Player player) {
        Block lookingBlock = player.getTargetBlock(null, 25);
        Vector v1 = new Vector((double)lookingBlock.getX() - player.getEyeLocation().getX(), (double)lookingBlock.getY() - player.getEyeLocation().getY(), (double)lookingBlock.getZ() - player.getEyeLocation().getZ());
        return v1.normalize();
    }

    int getTotalExp(Player p) {
        int xp = 0;
        int i = 1;
        while (i <= p.getLevel()) {
            if (i <= 16) {
                xp += 17;
            } else if (i > 16 && i <= 31) {
                xp += (i - 16) * 3 + 17;
            } else if (i > 31) {
                xp += (i - 31) * 7 + 62;
            }
            ++i;
        }
        return (int)((float)xp + (float)p.getExpToLevel() * p.getExp());
    }
}

