/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.utils;

import com.bergerkiller.bukkit.common.reflection.classes.CraftServerRef;
import com.bergerkiller.bukkit.common.reflection.classes.EntityTrackerRef;
import com.bergerkiller.bukkit.common.utils.ChunkUtil;
import com.bergerkiller.bukkit.common.utils.MathUtil;
import com.bergerkiller.bukkit.common.utils.NativeUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import net.minecraft.server.v1_4_R1.EntityTracker;
import net.minecraft.server.v1_4_R1.EntityTrackerEntry;
import net.minecraft.server.v1_4_R1.World;
import net.minecraft.server.v1_4_R1.WorldServer;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class WorldUtil
extends ChunkUtil {
    public static Random getRandom(org.bukkit.World world) {
        return NativeUtil.getNative((org.bukkit.World)world).random;
    }

    public static void removeEntity(Entity entity) {
        net.minecraft.server.v1_4_R1.Entity e = NativeUtil.getNative(entity);
        e.world.removeEntity(e);
        WorldUtil.getTracker(entity.getWorld()).untrackEntity(e);
    }

    public static void removeWorld(org.bukkit.World world) {
        Iterator<org.bukkit.World> iter = CraftServerRef.worlds.values().iterator();
        while (iter.hasNext()) {
            if (iter.next() != world) continue;
            iter.remove();
        }
        NativeUtil.getWorlds().remove(NativeUtil.getNative(world));
    }

    public static Collection<org.bukkit.World> getWorlds() {
        return CraftServerRef.worlds.values();
    }

    public static Collection<Entity> getEntities(org.bukkit.World world) {
        return NativeUtil.getEntities(NativeUtil.getNative((org.bukkit.World)world).entityList);
    }

    public static Collection<Player> getPlayers(org.bukkit.World world) {
        return NativeUtil.getPlayers(NativeUtil.getNative((org.bukkit.World)world).players);
    }

    public static EntityTracker getTracker(org.bukkit.World world) {
        return WorldUtil.getTracker((World)NativeUtil.getNative(world));
    }

    public static EntityTracker getTracker(World world) {
        return ((WorldServer)world).tracker;
    }

    public static EntityTrackerEntry getTrackerEntry(net.minecraft.server.v1_4_R1.Entity entity) {
        return (EntityTrackerEntry)WorldUtil.getTracker((World)entity.world).trackedEntities.get(entity.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityTrackerEntry setTrackerEntry(net.minecraft.server.v1_4_R1.Entity entity, EntityTrackerEntry tracker) {
        EntityTracker t = WorldUtil.getTracker(entity.world);
        Set<EntityTrackerEntry> trackers = EntityTrackerRef.trackerSet.get(t);
        EntityTracker entityTracker = t;
        synchronized (entityTracker) {
            EntityTrackerEntry old = (EntityTrackerEntry)t.trackedEntities.d(entity.id);
            if (old != null) {
                trackers.remove(old);
            }
            if (tracker != null) {
                trackers.add(tracker);
                t.trackedEntities.a(entity.id, (Object)tracker);
            }
            return old;
        }
    }

    public static void loadChunks(Location location, int radius) {
        WorldUtil.loadChunks(location.getWorld(), location.getX(), location.getZ(), radius);
    }

    public static void loadChunks(org.bukkit.World world, double xmid, double zmid, int radius) {
        WorldUtil.loadChunks(world, MathUtil.toChunk(xmid), MathUtil.toChunk(zmid), radius);
    }

    public static void loadChunks(org.bukkit.World world, int xmid, int zmid, int radius) {
        int cx = xmid - radius;
        while (cx <= xmid + radius) {
            int cz = zmid - radius;
            while (cz <= zmid + radius) {
                world.getChunkAt(cx, cz);
                ++cz;
            }
            ++cx;
        }
    }

    public static boolean isLoaded(Location location) {
        return WorldUtil.isLoaded(location.getWorld(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public static boolean isLoaded(Block block) {
        return WorldUtil.isLoaded(block.getWorld(), block.getX(), block.getY(), block.getZ());
    }

    public static boolean isLoaded(org.bukkit.World world, double x, double y, double z) {
        return WorldUtil.isLoaded(world, MathUtil.toChunk(x), MathUtil.toChunk(z));
    }

    public static boolean isLoaded(org.bukkit.World world, int x, int y, int z) {
        return WorldUtil.isLoaded(world, x >> 4, z >> 4);
    }

    public static boolean isLoaded(org.bukkit.World world, int chunkX, int chunkZ) {
        if (world == null) {
            return false;
        }
        return world.isChunkLoaded(chunkX, chunkZ);
    }

    public static boolean areChunksLoaded(org.bukkit.World world, int chunkCenterX, int chunkCenterZ, int chunkDistance) {
        return WorldUtil.areBlocksLoaded(world, chunkCenterX << 4, chunkCenterZ << 4, chunkDistance << 4);
    }

    public static boolean areBlocksLoaded(org.bukkit.World world, int blockCenterX, int blockCenterZ, int distance) {
        return NativeUtil.getNative(world).areChunksLoaded(blockCenterX, 0, blockCenterZ, distance);
    }
}

