/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.utils;

import com.bergerkiller.bukkit.common.utils.LogicUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.map.MapFont;
import org.bukkit.map.MinecraftFont;

public class StringUtil {
    public static final char CHAT_STYLE_CHAR = '\u00a7';
    public static final int SPACE_WIDTH = StringUtil.getWidth(' ');
    public static final String[] EMPTY_ARRAY = new String[0];

    public static String blockToString(Block block) {
        return String.valueOf(block.getWorld().getName()) + "_" + block.getX() + "_" + block.getY() + "_" + block.getZ();
    }

    public static Block stringToBlock(String str) {
        World world;
        int z;
        int y;
        int x;
        block7: {
            String[] s;
            block6: {
                s = str.split("_");
                if (s.length >= 4) break block6;
                return null;
            }
            try {
                x = Integer.parseInt(s[s.length - 3]);
                y = Integer.parseInt(s[s.length - 2]);
                z = Integer.parseInt(s[s.length - 1]);
                StringBuilder worldName = new StringBuilder(12);
                int i = 0;
                while (i < s.length - 3) {
                    if (i != 0) {
                        worldName.append('_');
                    }
                    worldName.append(s[i]);
                    ++i;
                }
                world = Bukkit.getServer().getWorld(worldName.toString());
                if (world != null) break block7;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return world.getBlockAt(x, y, z);
    }

    public static int getWidth(String ... text) {
        int width = 0;
        String[] stringArray = text;
        int n = text.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            int i = 0;
            while (i < part.length()) {
                char character = part.charAt(i);
                if (character != '\n') {
                    if (character == '\u00a7') {
                        ++i;
                    } else if (character == ' ') {
                        width += SPACE_WIDTH;
                    } else {
                        MapFont.CharacterSprite charsprite = MinecraftFont.Font.getChar(character);
                        if (charsprite != null) {
                            width += charsprite.getWidth();
                        }
                    }
                }
                ++i;
            }
            ++n2;
        }
        return width;
    }

    public static int countNrs(String str) {
        String result = "";
        Pattern pattern = Pattern.compile("\\d+");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            result = String.valueOf(result) + matcher.group();
        }
        return result != "" ? Integer.valueOf(result) : 0;
    }

    public static int getWidth(char character) {
        return MinecraftFont.Font.getChar(character).getWidth();
    }

    public static int firstIndexOf(String text, String ... values) {
        return StringUtil.firstIndexOf(text, 0, values);
    }

    public static int firstIndexOf(String text, int startindex, String ... values) {
        int i = -1;
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            int index = text.indexOf(value, startindex);
            if (index != -1 && (i == -1 || index < i)) {
                i = index;
            }
            ++n2;
        }
        return i;
    }

    public static String getFilledString(String text, int n) {
        StringBuffer outputBuffer = new StringBuffer(text.length() * n);
        int i = 0;
        while (i < n) {
            outputBuffer.append(text);
            ++i;
        }
        return outputBuffer.toString();
    }

    public static String getBefore(String text, String delimiter) {
        int index = text.lastIndexOf(delimiter);
        return index >= 0 ? text.substring(0, index) : "";
    }

    public static String getAfter(String text, String delimiter) {
        int index = text.indexOf(delimiter);
        return index >= 0 ? text.substring(index + 1) : "";
    }

    public static String[] remove(String[] input, int index) {
        if (index < 0 || index >= input.length) {
            return input;
        }
        String[] rval = new String[input.length - 1];
        System.arraycopy(input, 0, rval, 0, index);
        System.arraycopy(input, index + 1, rval, index, input.length - index - 1);
        return rval;
    }

    public static String combineNames(Set items) {
        return StringUtil.combineNames((Collection)items);
    }

    public static String combineNames(Collection items) {
        if (items == null || items.isEmpty()) {
            return "";
        }
        if (items.size() == 1) {
            Object item = items.iterator().next();
            return item == null ? "" : item.toString();
        }
        StringBuilder rval = new StringBuilder();
        int i = 0;
        for (Object item : items) {
            if (i == items.size() - 1) {
                rval.append(" and ");
            } else if (i > 0) {
                rval.append(", ");
            }
            if (item != null) {
                rval.append(item);
            }
            ++i;
        }
        return rval.toString();
    }

    public static String combineNames(String ... items) {
        return StringUtil.combineNames(Arrays.asList(items));
    }

    public static String combine(String separator, String ... parts) {
        return StringUtil.combine(separator, Arrays.asList(parts));
    }

    public static String combine(String separator, Collection<String> parts) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String line : parts) {
            if (!first) {
                builder.append(separator);
            }
            if (line != null) {
                builder.append(line);
            }
            first = false;
        }
        return builder.toString();
    }

    public static String[] convertArgs(String[] args) {
        ArrayList<String> tmpargs = new ArrayList<String>(args.length);
        boolean isCommenting = false;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (!isCommenting && (arg.startsWith("\"") || arg.startsWith("'"))) {
                if (arg.endsWith("\"") && arg.length() > 1) {
                    tmpargs.add(arg.substring(1, arg.length() - 1));
                } else {
                    isCommenting = true;
                    tmpargs.add(arg.substring(1));
                }
            } else if (isCommenting && (arg.endsWith("\"") || arg.endsWith("'"))) {
                arg = arg.substring(0, arg.length() - 1);
                arg = String.valueOf((String)tmpargs.get(tmpargs.size() - 1)) + " " + arg;
                tmpargs.set(tmpargs.size() - 1, arg);
                isCommenting = false;
            } else if (isCommenting) {
                arg = String.valueOf((String)tmpargs.get(tmpargs.size() - 1)) + " " + arg;
                tmpargs.set(tmpargs.size() - 1, arg);
            } else {
                tmpargs.add(arg);
            }
            ++n2;
        }
        return tmpargs.toArray(new String[0]);
    }

    public static boolean isChatCode(char character) {
        return LogicUtil.containsChar(character, '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'k', 'l', 'm', 'n', 'o', 'r');
    }

    public static int getSuccessiveCharCount(String value, char character) {
        return StringUtil.getSuccessiveCharCount(value, character, 0, value.length() - 1);
    }

    public static int getSuccessiveCharCount(String value, char character, int startindex) {
        return StringUtil.getSuccessiveCharCount(value, character, startindex, value.length() - startindex - 1);
    }

    public static int getSuccessiveCharCount(String value, char character, int startindex, int endindex) {
        int count = 0;
        int i = startindex;
        while (i <= endindex) {
            if (value.charAt(i) != character) break;
            ++count;
            ++i;
        }
        return count;
    }

    public static void replaceAll(StringBuilder builder, String from, String to) {
        int index = builder.indexOf(from);
        while (index != -1) {
            builder.replace(index, index + from.length(), to);
            index += to.length();
            index = builder.indexOf(from, index);
        }
    }

    public static ChatColor getColor(char code, ChatColor def) {
        ChatColor[] chatColorArray = ChatColor.values();
        int n = chatColorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChatColor color = chatColorArray[n2];
            if (code == color.toString().charAt(1)) {
                return color;
            }
            ++n2;
        }
        return def;
    }

    public static String ampToColor(String line) {
        return StringUtil.swapColorCodes(line, '&', '\u00a7');
    }

    public static String colorToAmp(String line) {
        return StringUtil.swapColorCodes(line, '\u00a7', '&');
    }

    public static String swapColorCodes(String line, char fromCode, char toCode) {
        StringBuilder builder = new StringBuilder(line);
        int i = 0;
        while (i < builder.length() - 1) {
            if (builder.charAt(i) == fromCode && StringUtil.isChatCode(builder.charAt(i + 1))) {
                builder.setCharAt(i, toCode);
                ++i;
            }
            ++i;
        }
        return builder.toString();
    }
}

