/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.utils;

import com.bergerkiller.bukkit.common.inventory.CraftRecipe;
import com.bergerkiller.bukkit.common.inventory.ItemParser;
import com.bergerkiller.bukkit.common.utils.NativeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.v1_4_R1.CraftingManager;
import net.minecraft.server.v1_4_R1.IRecipe;
import net.minecraft.server.v1_4_R1.RecipesFurnace;
import net.minecraft.server.v1_4_R1.TileEntityFurnace;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class RecipeUtil {
    private static final Map<Integer, Integer> fuelTimes = new HashMap<Integer, Integer>();

    static {
        Material[] materialArray = Material.values();
        int n = materialArray.length;
        int n2 = 0;
        while (n2 < n) {
            int fuel;
            Material material = materialArray[n2];
            net.minecraft.server.v1_4_R1.ItemStack item = new net.minecraft.server.v1_4_R1.ItemStack(material.getId(), 1, 0);
            if (item.getItem() != null && (fuel = TileEntityFurnace.fuelTime((net.minecraft.server.v1_4_R1.ItemStack)item)) > 0) {
                fuelTimes.put(material.getId(), fuel);
            }
            ++n2;
        }
    }

    public static Set<Integer> getFuelItems() {
        return fuelTimes.keySet();
    }

    public static Map<Integer, Integer> getFuelTimes() {
        return fuelTimes;
    }

    public static int getFuelTime(int itemid) {
        Integer rval = fuelTimes.get(itemid);
        return rval == null ? 0 : rval;
    }

    public static int getFuelTime(ItemStack item) {
        if (item == null) {
            return 0;
        }
        return RecipeUtil.getFuelTime(item.getTypeId()) * item.getAmount();
    }

    public static int getFuelTime(Material material) {
        return RecipeUtil.getFuelTime(material.getId());
    }

    public static boolean isFuelItem(int itemid) {
        return fuelTimes.containsKey(itemid);
    }

    public static boolean isFuelItem(Material material) {
        return RecipeUtil.isFuelItem(material.getId());
    }

    public static boolean isFuelItem(ItemStack item) {
        return RecipeUtil.isFuelItem(item.getTypeId());
    }

    public static boolean isHeatableItem(int itemid) {
        return RecipesFurnace.getInstance().recipes.containsKey(itemid);
    }

    public static boolean isHeatableItem(Material material) {
        return RecipeUtil.isFuelItem(material.getId());
    }

    public static boolean isHeatableItem(ItemStack item) {
        return RecipeUtil.isHeatableItem(item.getTypeId());
    }

    public static ItemStack getFurnaceResult(int itemid) {
        return NativeUtil.getItemStack(RecipesFurnace.getInstance().getResult(itemid));
    }

    public static ItemStack getFurnaceResult(ItemStack cooked) {
        return RecipeUtil.getFurnaceResult(cooked.getTypeId());
    }

    public static Set<Integer> getHeatableItems() {
        return RecipesFurnace.getInstance().recipes.keySet();
    }

    public static CraftRecipe[] getCraftingRequirements(int itemid, Integer data) {
        ArrayList<CraftRecipe> poss = new ArrayList<CraftRecipe>();
        for (IRecipe rec : RecipeUtil.getCraftRecipes()) {
            CraftRecipe crec;
            net.minecraft.server.v1_4_R1.ItemStack item = rec.b();
            if (item == null || item.id != itemid || data != null && data.intValue() != item.getData() || (crec = CraftRecipe.create(rec)) == null) continue;
            poss.add(crec);
        }
        return poss.toArray(new CraftRecipe[0]);
    }

    public static void craftItems(ItemParser parser, Inventory source) {
        if (parser.hasType()) {
            int limit = parser.hasAmount() ? parser.getAmount() : Integer.MAX_VALUE;
            Integer data = parser.hasData() ? Integer.valueOf(parser.getData()) : null;
            RecipeUtil.craftItems(parser.getTypeId(), data, source, limit);
        }
    }

    public static void craftItems(int itemid, Integer data, Inventory source, int limit) {
        CraftRecipe[] craftRecipeArray = RecipeUtil.getCraftingRequirements(itemid, data);
        int n = craftRecipeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CraftRecipe rec = craftRecipeArray[n2];
            limit -= rec.craftItems(source, limit);
            ++n2;
        }
    }

    private static List<IRecipe> getCraftRecipes() {
        return CraftingManager.getInstance().getRecipes();
    }
}

