/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.utils;

import com.bergerkiller.bukkit.common.StringReplaceBundle;
import com.bergerkiller.bukkit.common.utils.LogicUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.bukkit.DyeColor;
import org.bukkit.GrassSpecies;
import org.bukkit.Material;
import org.bukkit.TreeSpecies;
import org.bukkit.material.Leaves;
import org.bukkit.material.LongGrass;
import org.bukkit.material.MaterialData;
import org.bukkit.material.TexturedMaterial;
import org.bukkit.material.Tree;
import org.bukkit.material.Wool;

public class ParseUtil {
    private static final Set<String> yesValues = new HashSet<String>();
    private static final Set<String> noValues = new HashSet<String>();
    private static final HashMap<String, Material> MAT_SPECIAL = new HashMap();
    private static final StringReplaceBundle MAT_REPLACE = new StringReplaceBundle();

    static {
        yesValues.addAll(Arrays.asList("yes", "allow", "allowed", "true", "ye", "y", "t", "on", "enabled", "enable"));
        noValues.addAll(Arrays.asList("no", "none", "deny", "denied", "false", "n", "f", "off", "disabled", "disable"));
        MAT_REPLACE.add(" ", "_").add("DIAM_", "DIAMOND").add("LEAT_", "LEATHER").add("_", "");
        MAT_REPLACE.add("SHOVEL", "SPADE").add("SLAB", "STEP").add("GOLDEN", "GOLD").add("WOODEN", "WOOD");
        MAT_REPLACE.add("PRESSUREPLATE", "PLATE").add("PANTS", "LEGGINGS");
        MAT_REPLACE.add("REDSTONEDUST", "REDSTONE").add("REDSTONEREPEATER", "DIODE");
        MAT_REPLACE.add("SULPHER", "SULPHUR").add("SULPHOR", "SULPHUR").add("DOORBLOCK", "DOOR").add("REPEATER", "DIODE");
        MAT_REPLACE.add("LIGHTER", "FLINTANDSTEEL").add("LITPUMPKIN", "JACKOLANTERN");
        MAT_SPECIAL.put("CROP", Material.CROPS);
        MAT_SPECIAL.put("REDSTONETORCH", Material.REDSTONE_TORCH_ON);
        MAT_SPECIAL.put("BUTTON", Material.STONE_BUTTON);
        MAT_SPECIAL.put("PISTON", Material.PISTON_BASE);
        MAT_SPECIAL.put("STICKPISTON", Material.PISTON_STICKY_BASE);
        MAT_SPECIAL.put("MOSSSTONE", Material.MOSSY_COBBLESTONE);
        MAT_SPECIAL.put("STONESTAIR", Material.COBBLESTONE_STAIRS);
        MAT_SPECIAL.put("SANDSTAIR", Material.SANDSTONE_STAIRS);
        MAT_SPECIAL.put("GOLDAPPLE", Material.GOLDEN_APPLE);
        MAT_SPECIAL.put("APPLEGOLD", Material.GOLDEN_APPLE);
    }

    private static Material parseMaterialMain(String name, Material def) {
        Material m = ParseUtil.parseEnum(Material.class, name, null);
        if (m != null) {
            return m;
        }
        m = MAT_SPECIAL.get(name);
        if (m != null) {
            return m;
        }
        if (name.endsWith("S")) {
            return ParseUtil.parseMaterialMain(name.substring(0, name.length() - 1), def);
        }
        return def;
    }

    public static String filterNumeric(String text) {
        if (text == null) {
            return "";
        }
        StringBuilder rval = new StringBuilder(text.length());
        boolean hasComma = false;
        boolean hasDigit = false;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (Character.isDigit(c)) {
                rval.append(c);
                hasDigit = true;
            } else if (c == ' ') {
                if (hasDigit) {
                    break;
                }
            } else if (!(c != ',' && c != '.' || hasComma)) {
                rval.append('.');
                hasComma = true;
            }
            ++i;
        }
        return rval.toString();
    }

    public static boolean isNumeric(String text) {
        if (LogicUtil.nullOrEmpty(text)) {
            return false;
        }
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (!Character.isDigit(c) && c != '.' && c != ',') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isBool(String text) {
        return yesValues.contains(text = text.toLowerCase(Locale.ENGLISH).trim()) || noValues.contains(text);
    }

    public static boolean parseBool(String text) {
        return yesValues.contains(text.toLowerCase(Locale.ENGLISH).trim());
    }

    public static float parseFloat(String text, float def) {
        return ParseUtil.parseFloat(text, Float.valueOf(def)).floatValue();
    }

    public static Float parseFloat(String text, Float def) {
        try {
            return Float.valueOf(Float.parseFloat(ParseUtil.filterNumeric(text)));
        }
        catch (Exception ex) {
            return def;
        }
    }

    public static double parseDouble(String text, double def) {
        return ParseUtil.parseDouble(text, (Double)def);
    }

    public static Double parseDouble(String text, Double def) {
        try {
            return Double.parseDouble(ParseUtil.filterNumeric(text));
        }
        catch (Exception ex) {
            return def;
        }
    }

    public static long parseLong(String text, long def) {
        return ParseUtil.parseLong(text, (Long)def);
    }

    public static Long parseLong(String text, Long def) {
        try {
            return Long.parseLong(ParseUtil.filterNumeric(text));
        }
        catch (Exception ex) {
            return def;
        }
    }

    public static int parseInt(String text, int def) {
        return ParseUtil.parseInt(text, (Integer)def);
    }

    public static Integer parseInt(String text, Integer def) {
        try {
            return Integer.parseInt(ParseUtil.filterNumeric(text));
        }
        catch (Exception ex) {
            return def;
        }
    }

    public static long parseTime(String timestring) {
        long rval = 0L;
        if (!LogicUtil.nullOrEmpty(timestring)) {
            String[] parts = timestring.split(":");
            if (parts.length == 1) {
                rval = (long)(ParseUtil.parseDouble(parts[0], 0.0) * 1000.0);
            } else if (parts.length == 2) {
                rval = ParseUtil.parseLong(parts[0], 0L) * 60000L;
                rval += ParseUtil.parseLong(parts[1], 0L) * 1000L;
            } else if (parts.length == 3) {
                rval = ParseUtil.parseLong(parts[0], 0L) * 3600000L;
                rval += ParseUtil.parseLong(parts[1], 0L) * 60000L;
                rval += ParseUtil.parseLong(parts[2], 0L) * 1000L;
            }
        }
        return rval;
    }

    public static <T> T parseArray(T[] values, String text, T def) {
        if (LogicUtil.nullOrEmpty(text)) {
            return def;
        }
        text = text.toUpperCase(Locale.ENGLISH).replace("_", "").replace(" ", "");
        String[] names = new String[values.length];
        int i = 0;
        while (i < names.length) {
            names[i] = values[i].toString().toUpperCase(Locale.ENGLISH).replace("_", "");
            if (names[i].equals(text)) {
                return values[i];
            }
            ++i;
        }
        i = 0;
        while (i < names.length) {
            if (names[i].contains(text)) {
                return values[i];
            }
            ++i;
        }
        i = 0;
        while (i < names.length) {
            if (text.contains(names[i])) {
                return values[i];
            }
            ++i;
        }
        return def;
    }

    public static <T> T parseEnum(String text, T def) {
        return (T)ParseUtil.parseEnum(def.getClass(), text, def);
    }

    public static <T> T parseEnum(Class<T> enumClass, String text, T def) {
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException("Class '" + enumClass.getSimpleName() + "' is not an Enumeration!");
        }
        return ParseUtil.parseArray(enumClass.getEnumConstants(), text, def);
    }

    public static TreeSpecies parseTreeSpecies(String text, TreeSpecies def) {
        if ((text = text.toLowerCase(Locale.ENGLISH)).contains("oak")) {
            return TreeSpecies.GENERIC;
        }
        if (text.contains("pine") || text.contains("spruce")) {
            return TreeSpecies.REDWOOD;
        }
        return ParseUtil.parseEnum(TreeSpecies.class, text, def);
    }

    public static Material parseMaterial(String text, Material def) {
        if (LogicUtil.nullOrEmpty(text)) {
            return def;
        }
        try {
            Material m = Material.getMaterial((int)Integer.parseInt(text));
            return m == null ? def : m;
        }
        catch (Exception exception) {
            text = MAT_REPLACE.replace(text.trim().toUpperCase(Locale.ENGLISH));
            return ParseUtil.parseMaterialMain(text, def);
        }
    }

    public static Byte parseMaterialData(String text, Material material, Byte def) {
        try {
            return Byte.parseByte(text);
        }
        catch (NumberFormatException ex) {
            if (material == Material.WOOD) {
                TreeSpecies ts = ParseUtil.parseTreeSpecies(text, null);
                if (ts != null) {
                    return ts.getData();
                }
                return def;
            }
            MaterialData dat = material.getNewData((byte)0);
            if (dat instanceof TexturedMaterial) {
                TexturedMaterial tdat = (TexturedMaterial)dat;
                Material mat = ParseUtil.parseMaterial(text, null);
                if (mat == null) {
                    return def;
                }
                tdat.setMaterial(mat);
            } else if (dat instanceof Wool) {
                Wool wdat = (Wool)dat;
                DyeColor color = ParseUtil.parseEnum(DyeColor.class, text, null);
                if (color == null) {
                    return def;
                }
                wdat.setColor(color);
            } else if (dat instanceof Tree) {
                Tree tdat = (Tree)dat;
                TreeSpecies species = ParseUtil.parseTreeSpecies(text, null);
                if (species == null) {
                    return def;
                }
                tdat.setSpecies(species);
            } else if (dat instanceof Leaves) {
                Leaves tdat = (Leaves)dat;
                TreeSpecies species = ParseUtil.parseTreeSpecies(text, null);
                if (species == null) {
                    return def;
                }
                tdat.setSpecies(species);
            } else if (dat instanceof LongGrass) {
                LongGrass ldat = (LongGrass)dat;
                GrassSpecies species = ParseUtil.parseEnum(GrassSpecies.class, text, null);
                if (species == null) {
                    return def;
                }
                ldat.setSpecies(species);
            } else {
                return def;
            }
            return dat.getData();
        }
    }

    public static <T> T convert(Object object, Class<T> type) {
        return ParseUtil.convert(object, type, null);
    }

    public static <T> T convert(Object object, T def) {
        return (T)ParseUtil.convert(object, def.getClass(), def);
    }

    public static <T> T convert(Object object, Class<T> type, T def) {
        if (object == null) {
            return def;
        }
        Object rval = def;
        try {
            if (type == object.getClass()) {
                rval = object;
            } else if (type.equals(String.class)) {
                if (object instanceof Collection) {
                    Collection collection = (Collection)object;
                    StringBuilder builder = new StringBuilder(collection.size() * 100);
                    boolean first = true;
                    for (Object element : collection) {
                        if (!first) {
                            builder.append('\n');
                        }
                        builder.append(ParseUtil.convert(element, String.class, ""));
                        first = false;
                    }
                    rval = builder.toString();
                } else {
                    rval = object.toString();
                }
            } else if (type.equals(Material.class)) {
                rval = ParseUtil.parseMaterial(object.toString(), (Material)def);
            } else if (type.isEnum()) {
                rval = ParseUtil.parseEnum(type, object.toString(), def);
            } else if (type == Integer.class) {
                rval = ParseUtil.parseInt(object.toString(), (Integer)def);
            } else if (type == Double.class) {
                rval = ParseUtil.parseDouble(object.toString(), (Double)def);
            } else if (type == Float.class) {
                rval = ParseUtil.parseFloat(object.toString(), (Float)def);
            } else if (type == Long.class) {
                rval = ParseUtil.parseLong(object.toString(), (Long)def);
            }
        }
        catch (Exception ex) {
            rval = def;
        }
        return rval;
    }
}

