/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.utils;

import com.bergerkiller.bukkit.common.internal.CommonPlugin;
import com.bergerkiller.bukkit.common.protocol.CommonPacket;
import com.bergerkiller.bukkit.common.protocol.PacketFields;
import com.bergerkiller.bukkit.common.protocol.PacketListener;
import com.bergerkiller.bukkit.common.protocol.PacketType;
import com.bergerkiller.bukkit.common.utils.CommonUtil;
import com.bergerkiller.bukkit.common.utils.EntityUtil;
import com.bergerkiller.bukkit.common.utils.LogicUtil;
import com.bergerkiller.bukkit.common.utils.NativeUtil;
import com.bergerkiller.bukkit.common.utils.WorldUtil;
import java.util.Map;
import net.minecraft.server.v1_4_R1.Packet;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PacketUtil {
    private static final Map<Class<?>, Integer> packetsToIds = (Map)PacketFields.DEFAULT.getField("a").get(null);

    public static int getPacketId(Class<?> packetClass) {
        return packetsToIds.get(packetClass);
    }

    public static void registerPacketToId(Class<?> packetClass, int id) {
        packetsToIds.put(packetClass, id);
    }

    public static void sendPacket(Player player, Object packet) {
        PacketUtil.sendPacket(player, packet, true);
    }

    public static void sendPacket(Player player, Object packet, boolean throughListeners) {
        CommonPlugin.getInstance().sendPacket(player, packet, throughListeners);
    }

    public static void sendCommonPacket(Player player, CommonPacket packet, boolean throughListeners) {
        PacketUtil.sendPacket(player, packet.getHandle(), throughListeners);
    }

    public static void broadcastChunkPacket(Chunk chunk, Object packet, boolean throughListeners) {
        if (chunk == null || packet == null) {
            return;
        }
        for (Player player : WorldUtil.getPlayers(chunk.getWorld())) {
            if (!EntityUtil.isNearChunk((Entity)player, chunk.getX(), chunk.getZ(), CommonUtil.VIEW)) continue;
            PacketUtil.sendPacket(player, packet, throughListeners);
        }
    }

    public static void broadcastBlockPacket(Block block, Object packet, boolean throughListeners) {
        PacketUtil.broadcastBlockPacket(block.getWorld(), block.getX(), block.getZ(), packet, throughListeners);
    }

    public static void broadcastBlockPacket(World world, int x, int z, Object packet, boolean throughListeners) {
        if (world == null || packet == null) {
            return;
        }
        for (Player player : WorldUtil.getPlayers(world)) {
            if (!EntityUtil.isNearBlock((Entity)player, x, z, CommonUtil.BLOCKVIEW)) continue;
            PacketUtil.sendPacket(player, packet, throughListeners);
        }
    }

    public static void broadcastPacket(Object packet, boolean throughListeners) {
        for (Player player : CommonUtil.getOnlinePlayers()) {
            PacketUtil.sendPacket(player, packet, throughListeners);
        }
    }

    public static void addPacketListener(PacketListener listener, PacketType ... packets) {
        if (listener == null || LogicUtil.nullOrEmpty((Object[])packets)) {
            return;
        }
        PacketType[] packetTypeArray = packets;
        int n = packets.length;
        int n2 = 0;
        while (n2 < n) {
            PacketType packetType = packetTypeArray[n2];
            CommonPlugin.getInstance().addPacketListener(listener, packetType.getId());
            ++n2;
        }
    }

    public static void removePacketListener(PacketListener listener) {
        CommonPlugin.getInstance().removePacketListener(listener);
    }

    public static void broadcastPacketNearby(Location location, double radius, Object packet) {
        PacketUtil.broadcastPacketNearby(location.getWorld(), location.getX(), location.getY(), location.getZ(), radius, packet);
    }

    public static void broadcastPacketNearby(World world, double x, double y, double z, double radius, Object packet) {
        CommonUtil.getServerConfig().sendPacketNearby(x, y, z, radius, NativeUtil.getNative((World)world).dimension, (Packet)packet);
    }
}

