/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.utils;

import com.bergerkiller.bukkit.common.natives.NativeChunkWrapper;
import com.bergerkiller.bukkit.common.natives.NativeEntityWrapper;
import com.bergerkiller.bukkit.common.reflection.classes.BlockStateRef;
import com.bergerkiller.bukkit.common.reflection.classes.CraftItemStackRef;
import com.bergerkiller.bukkit.common.utils.CommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.server.v1_4_R1.Chunk;
import net.minecraft.server.v1_4_R1.ContainerAnvilInventory;
import net.minecraft.server.v1_4_R1.ContainerEnchantTableInventory;
import net.minecraft.server.v1_4_R1.Entity;
import net.minecraft.server.v1_4_R1.EntityItem;
import net.minecraft.server.v1_4_R1.EntityMinecart;
import net.minecraft.server.v1_4_R1.EntityPlayer;
import net.minecraft.server.v1_4_R1.IInventory;
import net.minecraft.server.v1_4_R1.InventoryCrafting;
import net.minecraft.server.v1_4_R1.InventoryMerchant;
import net.minecraft.server.v1_4_R1.ItemStack;
import net.minecraft.server.v1_4_R1.PlayerInventory;
import net.minecraft.server.v1_4_R1.TileEntityBeacon;
import net.minecraft.server.v1_4_R1.TileEntityBrewingStand;
import net.minecraft.server.v1_4_R1.TileEntityChest;
import net.minecraft.server.v1_4_R1.TileEntityDispenser;
import net.minecraft.server.v1_4_R1.TileEntityFurnace;
import net.minecraft.server.v1_4_R1.TileEntitySign;
import net.minecraft.server.v1_4_R1.World;
import net.minecraft.server.v1_4_R1.WorldServer;
import org.bukkit.block.Chest;
import org.bukkit.block.Dispenser;
import org.bukkit.block.Furnace;
import org.bukkit.block.Sign;
import org.bukkit.craftbukkit.v1_4_R1.CraftChunk;
import org.bukkit.craftbukkit.v1_4_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_4_R1.block.CraftChest;
import org.bukkit.craftbukkit.v1_4_R1.block.CraftDispenser;
import org.bukkit.craftbukkit.v1_4_R1.block.CraftFurnace;
import org.bukkit.craftbukkit.v1_4_R1.block.CraftSign;
import org.bukkit.craftbukkit.v1_4_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_4_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_4_R1.inventory.CraftInventoryAnvil;
import org.bukkit.craftbukkit.v1_4_R1.inventory.CraftInventoryBeacon;
import org.bukkit.craftbukkit.v1_4_R1.inventory.CraftInventoryBrewer;
import org.bukkit.craftbukkit.v1_4_R1.inventory.CraftInventoryCrafting;
import org.bukkit.craftbukkit.v1_4_R1.inventory.CraftInventoryEnchanting;
import org.bukkit.craftbukkit.v1_4_R1.inventory.CraftInventoryFurnace;
import org.bukkit.craftbukkit.v1_4_R1.inventory.CraftInventoryMerchant;
import org.bukkit.craftbukkit.v1_4_R1.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_4_R1.inventory.CraftItemStack;
import org.bukkit.entity.Item;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class NativeUtil {
    public static List<WorldServer> getWorlds() {
        try {
            List worlds = CommonUtil.getMCServer().worlds;
            if (worlds != null) {
                return worlds;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return new ArrayList<WorldServer>();
    }

    public static List<Entity> getEntities(org.bukkit.World world) {
        return NativeUtil.getNative((org.bukkit.World)world).entityList;
    }

    public static ItemStack getNative(org.bukkit.inventory.ItemStack stack) {
        if (stack instanceof CraftItemStack) {
            return CraftItemStackRef.handle.get(stack);
        }
        return CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)stack);
    }

    public static IInventory getNative(Inventory inv) {
        return inv instanceof CraftInventory ? ((CraftInventory)inv).getInventory() : null;
    }

    public static EntityItem getNative(Item item) {
        return NativeUtil.getNative((org.bukkit.entity.Entity)item, EntityItem.class);
    }

    public static EntityMinecart getNative(Minecart m) {
        return NativeUtil.getNative((org.bukkit.entity.Entity)m, EntityMinecart.class);
    }

    public static EntityPlayer getNative(Player p) {
        return NativeUtil.getNative((org.bukkit.entity.Entity)p, EntityPlayer.class);
    }

    public static <T extends Entity> T getNative(org.bukkit.entity.Entity e, Class<T> type) {
        return (T)((Entity)CommonUtil.tryCast(NativeUtil.getNative(e), type));
    }

    public static Entity getNative(org.bukkit.entity.Entity entity) {
        return entity instanceof CraftEntity ? ((CraftEntity)entity).getHandle() : null;
    }

    public static WorldServer getNative(org.bukkit.World world) {
        return world instanceof CraftWorld ? ((CraftWorld)world).getHandle() : null;
    }

    public static Chunk getNative(org.bukkit.Chunk chunk) {
        return chunk instanceof CraftChunk ? ((CraftChunk)chunk).getHandle() : null;
    }

    public static TileEntitySign getNative(Sign sign) {
        return sign instanceof CraftSign ? BlockStateRef.SIGN.get(sign) : null;
    }

    public static TileEntityFurnace getNative(Furnace furnace) {
        return furnace instanceof CraftFurnace ? BlockStateRef.FURNACE.get(furnace) : null;
    }

    public static TileEntityDispenser getNative(Dispenser dispenser) {
        return dispenser instanceof CraftDispenser ? BlockStateRef.DISPENSER.get(dispenser) : null;
    }

    public static TileEntityChest getNative(Chest chest) {
        return chest instanceof CraftChest ? BlockStateRef.CHEST.get(chest) : null;
    }

    public static Inventory getInventory(IInventory inventory) {
        if (inventory == null) {
            return null;
        }
        if (inventory instanceof InventoryCrafting) {
            return new CraftInventoryCrafting((InventoryCrafting)inventory, null);
        }
        if (inventory instanceof PlayerInventory) {
            return new CraftInventoryPlayer((PlayerInventory)inventory);
        }
        if (inventory instanceof TileEntityFurnace) {
            return new CraftInventoryFurnace((TileEntityFurnace)inventory);
        }
        if (inventory instanceof ContainerEnchantTableInventory) {
            return new CraftInventoryEnchanting((ContainerEnchantTableInventory)inventory);
        }
        if (inventory instanceof TileEntityBrewingStand) {
            return new CraftInventoryBrewer((IInventory)((TileEntityBrewingStand)inventory));
        }
        if (inventory instanceof InventoryMerchant) {
            return new CraftInventoryMerchant((InventoryMerchant)inventory);
        }
        if (inventory instanceof TileEntityBeacon) {
            return new CraftInventoryBeacon((TileEntityBeacon)inventory);
        }
        if (inventory instanceof ContainerAnvilInventory) {
            return new CraftInventoryAnvil((IInventory)((ContainerAnvilInventory)inventory));
        }
        return new CraftInventory(inventory);
    }

    public static <T extends Inventory> T getInventory(IInventory inventory, Class<T> type) {
        return (T)((Inventory)CommonUtil.tryCast(NativeUtil.getInventory(inventory), type));
    }

    public static Player getPlayer(EntityPlayer entity) {
        return NativeUtil.getEntity((Entity)entity, Player.class);
    }

    public static Item getItem(EntityItem entity) {
        return NativeUtil.getEntity((Entity)entity, Item.class);
    }

    public static <T extends org.bukkit.entity.Entity> T getEntity(Entity entity, Class<T> type) {
        return (T)((org.bukkit.entity.Entity)CommonUtil.tryCast(NativeUtil.getEntity(entity), type));
    }

    public static org.bukkit.entity.Entity getEntity(Entity entity) {
        return entity == null ? null : entity.getBukkitEntity();
    }

    public static org.bukkit.Chunk getChunk(Chunk chunk) {
        return chunk == null ? null : chunk.bukkitChunk;
    }

    public static org.bukkit.World getWorld(World world) {
        return world == null ? null : world.getWorld();
    }

    public static Collection<org.bukkit.Chunk> getChunks(Collection<Chunk> chunks) {
        return new NativeChunkWrapper(chunks);
    }

    public static Collection<EntityPlayer> getOnlinePlayers() {
        return CommonUtil.getServerConfig().players;
    }

    public static Collection<Player> getPlayers(Collection players) {
        return NativeUtil.getEntities(players, Player.class);
    }

    public static Collection<org.bukkit.entity.Entity> getEntities(Collection entities) {
        return NativeUtil.getEntities(entities, org.bukkit.entity.Entity.class);
    }

    public static <T extends org.bukkit.entity.Entity> Collection<T> getEntities(Collection entities, Class<T> type) {
        return new NativeEntityWrapper<T>(entities, type);
    }

    public static org.bukkit.inventory.ItemStack getItemStack(ItemStack itemstack) {
        return CraftItemStack.asCraftMirror((ItemStack)itemstack);
    }

    public static org.bukkit.inventory.ItemStack[] getItemStacks(ItemStack[] itemstacks) {
        org.bukkit.inventory.ItemStack[] stacks = new org.bukkit.inventory.ItemStack[itemstacks.length];
        int i = 0;
        while (i < stacks.length) {
            stacks[i] = NativeUtil.getItemStack(itemstacks[i]);
            ++i;
        }
        return stacks;
    }
}

