/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import net.minecraft.server.v1_4_R1.Entity;
import net.minecraft.server.v1_4_R1.FoodMetaData;
import net.minecraft.server.v1_4_R1.InventoryEnderChest;
import net.minecraft.server.v1_4_R1.MobEffect;
import net.minecraft.server.v1_4_R1.NBTBase;
import net.minecraft.server.v1_4_R1.NBTCompressedStreamTools;
import net.minecraft.server.v1_4_R1.NBTTagCompound;
import net.minecraft.server.v1_4_R1.NBTTagDouble;
import net.minecraft.server.v1_4_R1.NBTTagFloat;
import net.minecraft.server.v1_4_R1.NBTTagList;
import net.minecraft.server.v1_4_R1.PlayerInventory;

public class NBTUtil {
    public static NBTTagList doubleArrayToList(double ... values) {
        NBTTagList nbttaglist = new NBTTagList();
        int i = 0;
        while (i < values.length) {
            nbttaglist.add((NBTBase)new NBTTagDouble(null, values[i]));
            ++i;
        }
        return nbttaglist;
    }

    public static NBTTagList floatArrayToList(float ... values) {
        NBTTagList nbttaglist = new NBTTagList();
        int i = 0;
        while (i < values.length) {
            nbttaglist.add((NBTBase)new NBTTagFloat(null, values[i]));
            ++i;
        }
        return nbttaglist;
    }

    public static NBTTagCompound readCompound(InputStream stream) throws IOException {
        return NBTCompressedStreamTools.a((InputStream)stream);
    }

    public static void writeCompound(NBTTagCompound compound, OutputStream stream) throws IOException {
        NBTCompressedStreamTools.a((NBTTagCompound)compound, (OutputStream)stream);
    }

    public static MobEffect loadMobEffect(NBTTagCompound compound) {
        return MobEffect.b((NBTTagCompound)compound);
    }

    public static void saveUUID(UUID uuid, NBTTagCompound compound) {
        compound.setLong("WorldUUIDLeast", uuid.getLeastSignificantBits());
        compound.setLong("WorldUUIDMost", uuid.getMostSignificantBits());
    }

    public static UUID loadUUID(NBTTagCompound compound) {
        return new UUID(compound.getLong("WorldUUIDMost"), compound.getLong("WorldUUIDLeast"));
    }

    public static NBTTagCompound saveToNBT(Entity entity) {
        NBTTagCompound compound = new NBTTagCompound();
        entity.d(compound);
        return compound;
    }

    public static void saveToNBT(Entity entity, NBTTagCompound compound) {
        entity.d(compound);
    }

    public static void loadFromNBT(Entity entity, NBTTagCompound compound) {
        entity.e(compound);
    }

    public static void saveToNBT(FoodMetaData foodMetaData, NBTTagCompound compound) {
        foodMetaData.b(compound);
    }

    public static void loadFromNBT(FoodMetaData foodMetaData, NBTTagCompound compound) {
        foodMetaData.a(compound);
    }

    public static NBTTagList saveToNBT(PlayerInventory inventory) {
        return inventory.a(new NBTTagList());
    }

    public static void loadFromNBT(PlayerInventory inventory, NBTTagList list) {
        inventory.b(list);
    }

    public static NBTTagList saveToNBT(InventoryEnderChest inventory) {
        return inventory.g();
    }

    public static void loadFromNBT(InventoryEnderChest inventory, NBTTagList list) {
        inventory.a(list);
    }
}

