/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.utils;

import com.bergerkiller.bukkit.common.utils.FaceUtil;
import net.minecraft.server.v1_4_R1.MathHelper;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_4_R1.TrigMath;
import org.bukkit.craftbukkit.v1_4_R1.util.LongHash;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class MathUtil {
    private static final int CHUNK_BITS = 4;
    private static final int CHUNK_VALUES = 16;
    public static final float DEGTORAD = (float)Math.PI / 180;
    public static final float RADTODEG = 57.29578f;
    public static final double HALFROOTOFTWO = 0.707106781;

    public static double lengthSquared(double ... values) {
        double rval = 0.0;
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            rval += value * value;
            ++n2;
        }
        return rval;
    }

    public static double length(double ... values) {
        return Math.sqrt(MathUtil.lengthSquared(values));
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return MathUtil.length(x1 - x2, y1 - y2);
    }

    public static double distanceSquared(double x1, double y1, double x2, double y2) {
        return MathUtil.lengthSquared(x1 - x2, y1 - y2);
    }

    public static double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return MathUtil.length(x1 - x2, y1 - y2, z1 - z2);
    }

    public static double distanceSquared(double x1, double y1, double z1, double x2, double y2, double z2) {
        return MathUtil.lengthSquared(x1 - x2, y1 - y2, z1 - z2);
    }

    public static int getAngleDifference(int angle1, int angle2) {
        return Math.abs(MathUtil.wrapAngle(angle1 - angle2));
    }

    public static float getAngleDifference(float angle1, float angle2) {
        return Math.abs(MathUtil.wrapAngle(angle1 - angle2));
    }

    public static int wrapAngle(int angle) {
        int wrappedAngle = angle;
        while (wrappedAngle <= -180) {
            wrappedAngle += 360;
        }
        while (wrappedAngle > 180) {
            wrappedAngle -= 360;
        }
        return wrappedAngle;
    }

    public static float wrapAngle(float angle) {
        float wrappedAngle = angle;
        while (wrappedAngle <= -180.0f) {
            wrappedAngle += 360.0f;
        }
        while (wrappedAngle > 180.0f) {
            wrappedAngle -= 360.0f;
        }
        return wrappedAngle;
    }

    public static double normalize(double x, double z, double reqx, double reqz) {
        return Math.sqrt(MathUtil.lengthSquared(reqx, reqz) / MathUtil.lengthSquared(x, z));
    }

    public static float getLookAtYaw(Entity loc, Entity lookat) {
        return MathUtil.getLookAtYaw(loc.getLocation(), lookat.getLocation());
    }

    public static float getLookAtYaw(Block loc, Block lookat) {
        return MathUtil.getLookAtYaw(loc.getLocation(), lookat.getLocation());
    }

    public static float getLookAtYaw(Location loc, Location lookat) {
        return MathUtil.getLookAtYaw(lookat.getX() - loc.getX(), lookat.getZ() - loc.getZ());
    }

    public static float getLookAtYaw(Vector motion) {
        return MathUtil.getLookAtYaw(motion.getX(), motion.getZ());
    }

    public static float getLookAtYaw(double dx, double dz) {
        return MathUtil.atan2(dz, dx) - 180.0f;
    }

    public static float getLookAtPitch(double dX, double dY, double dZ) {
        return MathUtil.getLookAtPitch(dY, MathUtil.length(dX, dZ));
    }

    public static float getLookAtPitch(double dY, double dXZ) {
        return -MathUtil.atan(dY / dXZ);
    }

    public static float atan(double value) {
        return 57.29578f * (float)TrigMath.atan((double)value);
    }

    public static float atan2(double y, double x) {
        return 57.29578f * (float)TrigMath.atan2((double)y, (double)x);
    }

    public static int floor(double value) {
        int i = (int)value;
        return value < (double)i ? i - 1 : i;
    }

    public static Location move(Location loc, Vector offset) {
        return MathUtil.move(loc, offset.getX(), offset.getY(), offset.getZ());
    }

    public static Location move(Location loc, double dx, double dy, double dz) {
        Vector off = MathUtil.rotate(loc.getYaw(), loc.getPitch(), dx, dy, dz);
        double x = loc.getX() + off.getX();
        double y = loc.getY() + off.getY();
        double z = loc.getZ() + off.getZ();
        return new Location(loc.getWorld(), x, y, z, loc.getYaw(), loc.getPitch());
    }

    public static Vector rotate(float yaw, float pitch, Vector vector) {
        return MathUtil.rotate(yaw, pitch, vector.getX(), vector.getY(), vector.getZ());
    }

    public static Vector rotate(float yaw, float pitch, double x, double y, double z) {
        float angle = yaw * ((float)Math.PI / 180);
        double sinyaw = Math.sin(angle);
        double cosyaw = Math.cos(angle);
        angle = pitch * ((float)Math.PI / 180);
        double sinpitch = Math.sin(angle);
        double cospitch = Math.cos(angle);
        double newx = 0.0;
        double newy = 0.0;
        double newz = 0.0;
        newz -= x * cosyaw;
        newz -= y * sinyaw * sinpitch;
        newx += x * sinyaw;
        newx -= y * cosyaw * sinpitch;
        newy += y * cospitch;
        return new Vector(newx -= z * cosyaw * cospitch, newy -= z * sinpitch, newz -= z * sinyaw * cospitch);
    }

    public static double round(double value, int decimals) {
        double p = Math.pow(10.0, decimals);
        return (double)Math.round(value * p) / p;
    }

    public static double fixNaN(double value) {
        return MathUtil.fixNaN(value, 0.0);
    }

    public static double fixNaN(double value, double def) {
        return Double.isNaN(value) ? def : value;
    }

    public static int toChunk(double loc) {
        return MathHelper.floor((double)(loc / 16.0));
    }

    public static int toChunk(int loc) {
        return loc >> 4;
    }

    public static long toLong(int msw, int lsw) {
        return LongHash.toLong((int)msw, (int)lsw);
    }

    public static double useOld(double oldvalue, double newvalue, double peruseold) {
        return oldvalue + peruseold * (newvalue - oldvalue);
    }

    public static double lerp(double d1, double d2, double stage) {
        if (Double.isNaN(stage)) {
            return d2;
        }
        if (stage < 0.0) {
            return d1;
        }
        if (stage > 1.0) {
            return d2;
        }
        return d1 * (1.0 - stage) + d2 * stage;
    }

    public static Vector lerp(Vector vec1, Vector vec2, double stage) {
        Vector newvec = new Vector();
        newvec.setX(MathUtil.lerp(vec1.getX(), vec2.getX(), stage));
        newvec.setY(MathUtil.lerp(vec1.getY(), vec2.getY(), stage));
        newvec.setZ(MathUtil.lerp(vec1.getZ(), vec2.getZ(), stage));
        return newvec;
    }

    public static Location lerp(Location loc1, Location loc2, double stage) {
        Location newloc = new Location(loc1.getWorld(), 0.0, 0.0, 0.0);
        newloc.setX(MathUtil.lerp(loc1.getX(), loc2.getX(), stage));
        newloc.setY(MathUtil.lerp(loc1.getY(), loc2.getY(), stage));
        newloc.setZ(MathUtil.lerp(loc1.getZ(), loc2.getZ(), stage));
        newloc.setYaw((float)MathUtil.lerp(loc1.getYaw(), loc2.getYaw(), stage));
        newloc.setPitch((float)MathUtil.lerp(loc1.getPitch(), loc2.getPitch(), stage));
        return newloc;
    }

    public static boolean isInverted(double value1, double value2) {
        return value1 > 0.0 && value2 < 0.0 || value1 < 0.0 && value2 > 0.0;
    }

    public static Vector getDirection(float yaw, float pitch) {
        Vector vector = new Vector();
        double rotX = (float)Math.PI / 180 * yaw;
        double rotY = (float)Math.PI / 180 * pitch;
        vector.setY(-Math.sin(rotY));
        double h = Math.cos(rotY);
        vector.setX(-h * Math.sin(rotX));
        vector.setZ(h * Math.cos(rotX));
        return vector;
    }

    public static double clamp(double value, double limit) {
        return MathUtil.clamp(value, -limit, limit);
    }

    public static double clamp(double value, double min, double max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static float clamp(float value, float limit) {
        return MathUtil.clamp(value, -limit, limit);
    }

    public static float clamp(float value, float min, float max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static int clamp(int value, int limit) {
        return MathUtil.clamp(value, -limit, limit);
    }

    public static int clamp(int value, int min, int max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static int invert(int value, boolean negative) {
        return negative ? -value : value;
    }

    public static double invert(double value, boolean negative) {
        return negative ? -value : value;
    }

    public static long longHashToLong(int msw, int lsw) {
        return LongHash.toLong((int)msw, (int)lsw);
    }

    public static int longHashMsw(long key) {
        return LongHash.msw((long)key);
    }

    public static int longHashLsw(long key) {
        return LongHash.lsw((long)key);
    }

    public static void setVectorLength(Vector vector, double length) {
        MathUtil.setVectorLengthSquared(vector, Math.signum(length) * length * length);
    }

    public static void setVectorLengthSquared(Vector vector, double lengthsquared) {
        double vlength = vector.lengthSquared();
        if (Math.abs(vlength) > 1.0E-4) {
            if (lengthsquared < 0.0) {
                vector.multiply(-Math.sqrt(-lengthsquared / vlength));
            } else {
                vector.multiply(Math.sqrt(lengthsquared / vlength));
            }
        }
    }

    public static boolean isHeadingTo(BlockFace direction, Vector velocity) {
        return MathUtil.isHeadingTo(FaceUtil.faceToVector(direction), velocity);
    }

    public static boolean isHeadingTo(Location from, Location to, Vector velocity) {
        return MathUtil.isHeadingTo(new Vector(to.getX() - from.getX(), to.getY() - from.getY(), to.getZ() - from.getZ()), velocity);
    }

    public static boolean isHeadingTo(Vector offset, Vector velocity) {
        double dbefore = offset.lengthSquared();
        if (dbefore < 1.0E-4) {
            return true;
        }
        Vector clonedVelocity = velocity.clone();
        MathUtil.setVectorLengthSquared(clonedVelocity, dbefore);
        return dbefore > clonedVelocity.subtract(offset).lengthSquared();
    }
}

