/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.utils;

import com.bergerkiller.bukkit.common.MaterialProperty;
import com.bergerkiller.bukkit.common.MaterialTypeProperty;
import com.bergerkiller.bukkit.common.utils.LogicUtil;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class MaterialUtil {
    public static final MaterialTypeProperty ISDOOR = new MaterialTypeProperty(Material.WOOD_DOOR, Material.IRON_DOOR);
    public static final MaterialTypeProperty ISPISTONBASE = new MaterialTypeProperty(Material.PISTON_BASE, Material.PISTON_STICKY_BASE);
    public static final MaterialTypeProperty ISREDSTONETORCH = new MaterialTypeProperty(Material.REDSTONE_TORCH_OFF, Material.REDSTONE_TORCH_ON);
    public static final MaterialTypeProperty ISDIODE = new MaterialTypeProperty(Material.DIODE_BLOCK_OFF, Material.DIODE_BLOCK_ON);
    public static final MaterialTypeProperty ISBUCKET = new MaterialTypeProperty(Material.WATER_BUCKET, Material.LAVA_BUCKET, Material.BUCKET);
    public static final MaterialTypeProperty ISRAILS = new MaterialTypeProperty(Material.RAILS, Material.POWERED_RAIL, Material.DETECTOR_RAIL);
    public static final MaterialTypeProperty ISSIGN = new MaterialTypeProperty(Material.WALL_SIGN, Material.SIGN_POST);
    public static final MaterialTypeProperty ISPRESSUREPLATE = new MaterialTypeProperty(Material.WOOD_PLATE, Material.STONE_PLATE);
    public static final MaterialTypeProperty ISINTERACTABLE = new MaterialTypeProperty(Material.LEVER, Material.WOOD_DOOR, Material.IRON_DOOR, Material.TRAP_DOOR, Material.CHEST, Material.ENDER_CHEST, Material.FURNACE, Material.BURNING_FURNACE, Material.DISPENSER, Material.WORKBENCH, Material.DIODE_BLOCK_ON, Material.DIODE_BLOCK_OFF, Material.BED, Material.CAKE, Material.NOTE_BLOCK, Material.JUKEBOX);
    public static final MaterialProperty<Boolean> SUFFOCATES = new MaterialProperty<Boolean>(){

        @Override
        public Boolean get(int typeId) {
            return net.minecraft.server.v1_4_R1.Block.i((int)typeId);
        }
    };
    public static final MaterialProperty<Boolean> ISSOLID = new MaterialProperty<Boolean>(){

        @Override
        public Boolean get(int typeId) {
            return net.minecraft.server.v1_4_R1.Block.q[typeId];
        }
    };
    public static final MaterialProperty<Boolean> ISPOWERSOURCE = new MaterialProperty<Boolean>(){

        @Override
        public Boolean get(int typeId) {
            net.minecraft.server.v1_4_R1.Block block = net.minecraft.server.v1_4_R1.Block.byId[typeId];
            return block == null ? false : block.isPowerSource();
        }
    };
    public static final MaterialProperty<Integer> EMISSION = new MaterialProperty<Integer>(){

        @Override
        public Integer get(int typeId) {
            return net.minecraft.server.v1_4_R1.Block.lightEmission[typeId];
        }
    };
    public static final MaterialProperty<Integer> OPACITY = new MaterialProperty<Integer>(){

        @Override
        public Integer get(int typeId) {
            return net.minecraft.server.v1_4_R1.Block.lightBlock[typeId];
        }
    };

    public static boolean isType(int material, int ... types) {
        return LogicUtil.containsInt(material, types);
    }

    public static boolean isType(Material material, Material ... types) {
        return LogicUtil.contains(material, types);
    }

    public static boolean isType(int material, Material ... types) {
        return MaterialUtil.isType(Material.getMaterial((int)material), types);
    }

    public static boolean isType(Block block, Material ... types) {
        return MaterialUtil.isType(block.getTypeId(), types);
    }

    public static boolean isType(Block block, int ... types) {
        return MaterialUtil.isType(block.getTypeId(), types);
    }
}

