/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.utils;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.server.v1_4_R1.ItemStack;

public class LogicUtil {
    public static boolean bothNullOrEqual(Object value1, Object value2) {
        return value1 == null ? value2 == null : value1.equals(value2);
    }

    public static boolean nullOrEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean nullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean nullOrEmpty(String text) {
        return text == null || text.isEmpty();
    }

    public static boolean nullOrEmpty(ItemStack item) {
        return item == null || item.id == 0 || item.count < 1;
    }

    public static boolean nullOrEmpty(org.bukkit.inventory.ItemStack item) {
        return item == null || item.getTypeId() == 0 || item.getAmount() < 1;
    }

    public static boolean nullOrEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static <T> T fixNull(T value, T def) {
        return value == null ? def : value;
    }

    public static <T> T getList(List<T> list, int index, T def) {
        if (index < 0 || list == null || index >= list.size()) {
            return def;
        }
        return list.get(index);
    }

    public static <T> T getArray(T[] array, int index, T def) {
        if (index < 0 || array == null || index >= array.length) {
            return def;
        }
        return array[index];
    }

    public static <T> T[] createArray(Class<T> type, int length) {
        return (Object[])Array.newInstance(type, length);
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> type) {
        return collection.toArray(LogicUtil.createArray(type, collection.size()));
    }

    public static boolean containsAll(Map<?, ?> map, Map<?, ?> contents) {
        for (Map.Entry<?, ?> entry : contents.entrySet()) {
            Object value = map.get(entry.getKey());
            if (!(value == null ? entry.getValue() != null || !map.containsKey(entry.getKey()) : !value.equals(entry.getValue()))) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean contains(T value, T ... values) {
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T v = TArray[n2];
            if (LogicUtil.bothNullOrEqual(v, value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean containsByte(byte value, byte ... values) {
        byte[] byArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            byte v = byArray[n2];
            if (v == value) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean containsChar(char value, char ... values) {
        char[] cArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            char v = cArray[n2];
            if (v == value) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean containsInt(int value, int ... values) {
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int v = nArray[n2];
            if (v == value) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean containsBool(byte value, byte ... values) {
        byte[] byArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            byte v = byArray[n2];
            if (v == value) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

