/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.utils;

import com.bergerkiller.bukkit.common.inventory.InventoryBaseImpl;
import com.bergerkiller.bukkit.common.inventory.ItemParser;
import com.bergerkiller.bukkit.common.utils.LogicUtil;
import com.bergerkiller.bukkit.common.utils.NativeUtil;
import java.util.Map;
import net.minecraft.server.v1_4_R1.Entity;
import net.minecraft.server.v1_4_R1.EntityItem;
import org.bukkit.craftbukkit.v1_4_R1.inventory.CraftItemStack;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Item;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ItemUtil {
    public static boolean canTransferAll(ItemStack[] from, Inventory to) {
        return ItemUtil.canTransferAll(from, to.getContents());
    }

    public static boolean canTransferAll(ItemStack[] from, ItemStack[] to) {
        InventoryBaseImpl invto = new InventoryBaseImpl(to, true);
        ItemStack[] itemStackArray = ItemUtil.cloneItems(from);
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack item = itemStackArray[n2];
            ItemUtil.transfer(item, invto, Integer.MAX_VALUE);
            if (!LogicUtil.nullOrEmpty(item)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static int testTransfer(ItemStack from, Inventory to) {
        int startAmount;
        if (LogicUtil.nullOrEmpty(from)) {
            return 0;
        }
        int fromAmount = startAmount = from.getAmount();
        ItemStack[] itemStackArray = to.getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack item = itemStackArray[n2];
            if ((fromAmount -= ItemUtil.testTransfer(from, item)) <= 0) break;
            ++n2;
        }
        return startAmount - fromAmount;
    }

    public static int testTransfer(ItemStack from, ItemStack to) {
        if (LogicUtil.nullOrEmpty(from)) {
            return 0;
        }
        if (LogicUtil.nullOrEmpty(to)) {
            return Math.min(from.getAmount(), ItemUtil.getMaxSize(from));
        }
        if (ItemUtil.equalsIgnoreAmount(from, to)) {
            return Math.min(from.getAmount(), ItemUtil.getMaxSize(to) - to.getAmount());
        }
        return 0;
    }

    public static int transfer(Inventory from, Inventory to, ItemParser parser, int maxAmount) {
        int startAmount;
        int amountToTransfer = startAmount = maxAmount < 0 ? Integer.MAX_VALUE : maxAmount;
        int i = 0;
        while (i < from.getSize() && amountToTransfer > 0) {
            int tmptrans;
            ItemStack item = from.getItem(i);
            if (!LogicUtil.nullOrEmpty(item) && (parser == null || parser.match(item)) && (tmptrans = ItemUtil.transfer(item, to, amountToTransfer)) > 0) {
                amountToTransfer -= tmptrans;
                from.setItem(i, item);
            }
            ++i;
        }
        return startAmount - amountToTransfer;
    }

    public static int transfer(ItemStack from, Inventory to, int maxAmount) {
        int tmptrans;
        ItemStack toitem;
        int startAmount;
        int n = startAmount = maxAmount < 0 ? Integer.MAX_VALUE : maxAmount;
        if (startAmount == 0 || LogicUtil.nullOrEmpty(from)) {
            return 0;
        }
        int amountToTransfer = startAmount;
        int i = 0;
        while (i < to.getSize()) {
            toitem = to.getItem(i);
            if (!LogicUtil.nullOrEmpty(toitem) && (tmptrans = ItemUtil.transfer(from, toitem, amountToTransfer)) > 0) {
                to.setItem(i, toitem);
                if ((amountToTransfer -= tmptrans) <= 0 || LogicUtil.nullOrEmpty(from)) break;
            }
            ++i;
        }
        if (amountToTransfer > 0 && from.getAmount() > 0) {
            i = 0;
            while (i < to.getSize()) {
                toitem = to.getItem(i);
                if (LogicUtil.nullOrEmpty(toitem) && (tmptrans = ItemUtil.transfer(from, toitem = ItemUtil.emptyItem(), amountToTransfer)) > 0) {
                    to.setItem(i, toitem);
                    if ((amountToTransfer -= tmptrans) <= 0 || LogicUtil.nullOrEmpty(from)) break;
                }
                ++i;
            }
        }
        return startAmount - amountToTransfer;
    }

    public static int transfer(Inventory from, ItemStack to, ItemParser parser, int maxAmount) {
        int startAmount;
        int amountToTransfer = startAmount = maxAmount < 0 ? Integer.MAX_VALUE : maxAmount;
        int i = 0;
        while (i < from.getSize() && amountToTransfer > 0) {
            block3: {
                ItemStack item;
                block4: {
                    item = from.getItem(i);
                    if (LogicUtil.nullOrEmpty(item)) break block3;
                    if (!LogicUtil.nullOrEmpty(to)) break block4;
                    if (parser != null && !parser.match(item)) break block3;
                    ItemUtil.transferInfo(item, to);
                }
                amountToTransfer -= ItemUtil.transfer(item, to, amountToTransfer);
                from.setItem(i, item);
            }
            ++i;
        }
        return startAmount - amountToTransfer;
    }

    public static int transfer(ItemStack from, ItemStack to, int maxAmount) {
        if (LogicUtil.nullOrEmpty(from) || to == null) {
            return 0;
        }
        int amountToTransfer = Math.min(maxAmount < 0 ? Integer.MAX_VALUE : maxAmount, from.getAmount());
        if (LogicUtil.nullOrEmpty(to)) {
            if ((amountToTransfer = Math.min(amountToTransfer, ItemUtil.getMaxSize(from))) <= 0) {
                return 0;
            }
            ItemUtil.transferInfo(from, to);
            to.setAmount(amountToTransfer);
            ItemUtil.subtractAmount(from, amountToTransfer);
            return amountToTransfer;
        }
        if ((amountToTransfer = Math.min(amountToTransfer, ItemUtil.getMaxSize(to) - to.getAmount())) <= 0 || !ItemUtil.equalsIgnoreAmount(from, to)) {
            return 0;
        }
        ItemUtil.addAmount(to, amountToTransfer);
        ItemUtil.subtractAmount(from, amountToTransfer);
        return amountToTransfer;
    }

    public static void transferInfo(ItemStack from, ItemStack to) {
        to.setTypeId(from.getTypeId());
        to.setDurability(from.getDurability());
        Map it = from.getEnchantments();
        for (Enchantment e : it.keySet()) {
            Map it2 = to.getEnchantments();
            for (Enchantment e2 : it2.keySet()) {
                if (!e.conflictsWith(e2)) continue;
            }
            int a = (Integer)it.get(e);
            if (!e.canEnchantItem(to) || e.getMaxLevel() > a) continue;
            to.addEnchantment(e, a);
        }
    }

    public static boolean equalsIgnoreAmount(ItemStack item1, ItemStack item2) {
        if (item1.getTypeId() != item2.getTypeId() || item1.getDurability() != item2.getDurability()) {
            return false;
        }
        Map ench1 = item1.getEnchantments();
        Map ench2 = item2.getEnchantments();
        boolean hasEnchantments = !LogicUtil.nullOrEmpty(ench1);
        if (hasEnchantments != !LogicUtil.nullOrEmpty(ench2)) {
            return false;
        }
        return !hasEnchantments || ench1.size() == ench2.size() && LogicUtil.containsAll(ench1, ench2);
    }

    public static void removeItems(Inventory inventory, ItemStack item) {
        ItemUtil.removeItems(inventory, item.getTypeId(), item.getDurability(), item.getAmount());
    }

    public static void removeItems(Inventory inventory, int itemid, int data, int amount) {
        int countToRemove = amount < 0 ? Integer.MAX_VALUE : amount;
        int i = 0;
        while (i < inventory.getSize()) {
            ItemStack item = inventory.getItem(i);
            if (!(LogicUtil.nullOrEmpty(item) || item.getTypeId() != itemid || data != -1 && item.getDurability() != data)) {
                if (item.getAmount() <= countToRemove) {
                    countToRemove -= item.getAmount();
                    inventory.setItem(i, null);
                } else {
                    ItemUtil.addAmount(item, -countToRemove);
                    countToRemove = 0;
                    inventory.setItem(i, item);
                    break;
                }
            }
            ++i;
        }
    }

    public static ItemStack emptyItem() {
        return CraftItemStack.asCraftMirror((net.minecraft.server.v1_4_R1.ItemStack)new net.minecraft.server.v1_4_R1.ItemStack(0, 0, 0));
    }

    public static Item respawnItem(Item bitem) {
        bitem.remove();
        EntityItem item = NativeUtil.getNative(bitem);
        EntityItem newItem = new EntityItem(item.world, item.locX, item.locY, item.locZ, item.getItemStack());
        newItem.fallDistance = item.fallDistance;
        newItem.fireTicks = item.fireTicks;
        newItem.pickupDelay = item.pickupDelay;
        newItem.motX = item.motX;
        newItem.motY = item.motY;
        newItem.motZ = item.motZ;
        newItem.age = item.age;
        newItem.world.addEntity((Entity)newItem);
        return NativeUtil.getItem(newItem);
    }

    public static ItemStack[] getClonedContents(Inventory inventory) {
        ItemStack[] rval = new ItemStack[inventory.getSize()];
        int i = 0;
        while (i < rval.length) {
            rval[i] = ItemUtil.cloneItem(inventory.getItem(i));
            ++i;
        }
        return rval;
    }

    public static ItemStack cloneItem(ItemStack stack) {
        return stack == null ? null : stack.clone();
    }

    public static ItemStack[] cloneItems(ItemStack[] input) {
        ItemStack[] cloned = new ItemStack[input.length];
        int i = 0;
        while (i < cloned.length) {
            cloned[i] = ItemUtil.cloneItem(input[i]);
            ++i;
        }
        return cloned;
    }

    public static void subtractAmount(ItemStack item, int amount) {
        ItemUtil.addAmount(item, -amount);
    }

    public static void addAmount(ItemStack item, int amount) {
        item.setAmount(Math.max(item.getAmount() + amount, 0));
    }

    public static ItemStack findItem(Inventory inventory, int typeId, int data) {
        ItemStack rval = null;
        int itemData = data;
        int itemTypeId = typeId;
        ItemStack[] itemStackArray = inventory.getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                ItemStack item;
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                item = itemStackArray[n2];
                                if (LogicUtil.nullOrEmpty(item)) break block6;
                                if (itemTypeId != -1) break block7;
                                itemTypeId = item.getTypeId();
                                break block8;
                            }
                            if (itemTypeId != item.getTypeId()) break block6;
                        }
                        if (itemData != -1) break block9;
                        itemData = item.getDurability();
                        break block10;
                    }
                    if (item.getDurability() != itemData) break block6;
                }
                if (rval == null) {
                    rval = item.clone();
                } else {
                    ItemUtil.addAmount(rval, item.getAmount());
                }
            }
            ++n2;
        }
        return rval;
    }

    public static int getItemCount(Inventory inventory, int typeid, int data) {
        if (typeid < 0) {
            int count = 0;
            ItemStack[] itemStackArray = inventory.getContents();
            int n = itemStackArray.length;
            int n2 = 0;
            while (n2 < n) {
                ItemStack item = itemStackArray[n2];
                if (!LogicUtil.nullOrEmpty(item)) {
                    count += item.getAmount();
                }
                ++n2;
            }
            return count;
        }
        ItemStack rval = ItemUtil.findItem(inventory, typeid, data);
        return rval == null ? 0 : rval.getAmount();
    }

    public static int getMaxSize(ItemStack stack) {
        if (LogicUtil.nullOrEmpty(stack)) {
            return 0;
        }
        net.minecraft.server.v1_4_R1.ItemStack nitem = NativeUtil.getNative(stack);
        if (nitem == null) {
            return 0;
        }
        net.minecraft.server.v1_4_R1.Item item = nitem.getItem();
        if (item == null) {
            return 0;
        }
        return item.getMaxStackSize();
    }
}

