/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.utils;

import com.bergerkiller.bukkit.common.internal.CommonPlugin;
import com.bergerkiller.bukkit.common.reflection.classes.EntityRef;
import com.bergerkiller.bukkit.common.reflection.classes.WorldServerRef;
import com.bergerkiller.bukkit.common.utils.CommonUtil;
import com.bergerkiller.bukkit.common.utils.EntityPropertyUtil;
import com.bergerkiller.bukkit.common.utils.MathUtil;
import com.bergerkiller.bukkit.common.utils.NativeUtil;
import com.bergerkiller.bukkit.common.utils.WorldUtil;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.v1_4_R1.Chunk;
import net.minecraft.server.v1_4_R1.EntityPlayer;
import net.minecraft.server.v1_4_R1.EntityTrackerEntry;
import net.minecraft.server.v1_4_R1.IntHashMap;
import net.minecraft.server.v1_4_R1.MathHelper;
import net.minecraft.server.v1_4_R1.World;
import net.minecraft.server.v1_4_R1.WorldServer;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_4_R1.entity.CraftEntity;
import org.bukkit.entity.Entity;

public class EntityUtil
extends EntityPropertyUtil {
    public static <T extends Entity> T getEntity(org.bukkit.World world, UUID uid, Class<T> type) {
        return (T)((Entity)CommonUtil.tryCast(EntityUtil.getEntity(world, uid), type));
    }

    public static Entity getEntity(org.bukkit.World world, UUID uid) {
        net.minecraft.server.v1_4_R1.Entity e = EntityUtil.getEntity((World)NativeUtil.getNative(world), uid);
        return e == null ? null : NativeUtil.getEntity(e);
    }

    public static net.minecraft.server.v1_4_R1.Entity getEntity(World world, UUID uid) {
        for (net.minecraft.server.v1_4_R1.Entity e : world.entityList) {
            if (!e.uniqueId.equals(uid)) continue;
            return e;
        }
        return null;
    }

    public static void addEntity(Entity entity) {
        net.minecraft.server.v1_4_R1.Entity nmsentity = NativeUtil.getNative(entity);
        nmsentity.world.getChunkAt(MathUtil.toChunk(nmsentity.locX), MathUtil.toChunk(nmsentity.locZ));
        nmsentity.dead = false;
        nmsentity.world.addEntity(nmsentity);
    }

    public static void setEntity(net.minecraft.server.v1_4_R1.Entity toreplace, net.minecraft.server.v1_4_R1.Entity with) {
        EntityUtil.setEntity(toreplace, with, WorldUtil.getTrackerEntry(toreplace));
    }

    public static void setEntity(final net.minecraft.server.v1_4_R1.Entity toreplace, final net.minecraft.server.v1_4_R1.Entity with, EntityTrackerEntry tracker) {
        with.locX = toreplace.locX;
        with.locY = toreplace.locY;
        with.locZ = toreplace.locZ;
        EntityRef.chunkX.transfer(toreplace, with);
        EntityRef.chunkY.transfer(toreplace, with);
        EntityRef.chunkZ.transfer(toreplace, with);
        with.world = toreplace.world;
        with.id = toreplace.id;
        toreplace.dead = true;
        with.dead = false;
        EntityRef.bukkitEntity.transfer(toreplace, with);
        ((CraftEntity)NativeUtil.getEntity(with)).setHandle(with);
        if (toreplace.passenger != null) {
            toreplace.passenger.setPassengerOf(with);
        }
        Chunk chunk = toreplace.world.chunkProvider.getChunkAt(EntityRef.chunkX.get(with).intValue(), EntityRef.chunkZ.get(with).intValue());
        List worldEntities = toreplace.world.entityList;
        int i = 0;
        while (i < worldEntities.size()) {
            if (((net.minecraft.server.v1_4_R1.Entity)worldEntities.get((int)i)).id == toreplace.id) {
                toreplace.world.entityList.set(i, with);
                break;
            }
            ++i;
        }
        final IntHashMap entitiesById = WorldServerRef.entitiesById.get(toreplace.world);
        if (entitiesById.d(toreplace.id) == null) {
            CommonUtil.nextTick(new Runnable(){

                @Override
                public void run() {
                    entitiesById.a(toreplace.id, (Object)with);
                }
            });
        } else {
            entitiesById.a(toreplace.id, (Object)with);
        }
        int chunkY = EntityRef.chunkY.get(with);
        if (!EntityUtil.replaceInChunk(chunk, chunkY, toreplace, with)) {
            int y = 0;
            while (y < chunk.entitySlices.length) {
                if (y != chunkY && EntityUtil.replaceInChunk(chunk, y, toreplace, with)) break;
                ++y;
            }
        }
        tracker.tracker = with;
        WorldUtil.setTrackerEntry(toreplace, tracker);
    }

    private static boolean replaceInChunk(Chunk chunk, int chunkY, net.minecraft.server.v1_4_R1.Entity toreplace, net.minecraft.server.v1_4_R1.Entity with) {
        List list = chunk.entitySlices[chunkY];
        int i = 0;
        while (i < list.size()) {
            if (((net.minecraft.server.v1_4_R1.Entity)list.get((int)i)).id == toreplace.id) {
                list.set(i, with);
                chunk.m = true;
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isIgnored(Entity entity) {
        return CommonPlugin.getInstance().isEntityIgnored(entity);
    }

    public static boolean isNearChunk(Entity entity, int cx, int cz, int chunkview) {
        return EntityUtil.isNearChunk(NativeUtil.getNative(entity), cx, cz, chunkview);
    }

    public static boolean isNearChunk(net.minecraft.server.v1_4_R1.Entity entity, int cx, int cz, int chunkview) {
        if (Math.abs(MathUtil.toChunk(entity.locX) - cx) > chunkview) {
            return false;
        }
        return Math.abs(MathUtil.toChunk(entity.locZ) - cz) <= chunkview;
    }

    public static boolean isNearBlock(Entity entity, int bx, int bz, int blockview) {
        return EntityUtil.isNearBlock(NativeUtil.getNative(entity), bx, bz, blockview);
    }

    public static boolean isNearBlock(net.minecraft.server.v1_4_R1.Entity entity, int bx, int bz, int blockview) {
        if (Math.abs(MathHelper.floor((double)entity.locX) - bx) > blockview) {
            return false;
        }
        return Math.abs(MathHelper.floor((double)entity.locZ) - bz) <= blockview;
    }

    public static void teleportNextTick(final Entity entity, final Location to) {
        CommonUtil.nextTick(new Runnable(){

            @Override
            public void run() {
                EntityUtil.teleport(entity, to);
            }
        });
    }

    public static boolean teleport(Entity entity, Location to) {
        return EntityUtil.teleport(NativeUtil.getNative(entity), to);
    }

    public static boolean teleport(final net.minecraft.server.v1_4_R1.Entity entity, Location to) {
        WorldServer newworld = NativeUtil.getNative(to.getWorld());
        WorldUtil.loadChunks(to, 3);
        if (entity.world != newworld && !(entity instanceof EntityPlayer)) {
            final net.minecraft.server.v1_4_R1.Entity passenger = entity.passenger;
            if (passenger != null) {
                entity.passenger = null;
                passenger.vehicle = null;
                if (EntityUtil.teleport(passenger, to)) {
                    CommonUtil.nextTick(new Runnable(){

                        @Override
                        public void run() {
                            passenger.setPassengerOf(entity);
                        }
                    });
                }
            }
            entity.world.removeEntity(entity);
            entity.dead = false;
            entity.world = newworld;
            entity.setLocation(to.getX(), to.getY(), to.getZ(), to.getYaw(), to.getPitch());
            entity.world.addEntity(entity);
            return true;
        }
        return NativeUtil.getEntity(entity).teleport(to);
    }
}

