/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.utils;

import com.bergerkiller.bukkit.common.utils.LogicUtil;
import java.util.ArrayList;
import java.util.Locale;
import org.bukkit.Material;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.Monster;
import org.bukkit.entity.NPC;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Squid;

public class EntityGroupingUtil {
    public static final String[] animalNames;
    public static final String[] monsterNames;
    public static final String[] npcNames;

    static {
        ArrayList<String> animals = new ArrayList<String>();
        ArrayList<String> monsters = new ArrayList<String>();
        ArrayList<String> npcs = new ArrayList<String>();
        try {
            EntityType[] entityTypeArray = EntityType.values();
            int n = entityTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                EntityType type = entityTypeArray[n2];
                if (EntityGroupingUtil.isAnimal(type)) {
                    animals.add(EntityGroupingUtil.getName(type));
                }
                if (EntityGroupingUtil.isMonster(type)) {
                    monsters.add(EntityGroupingUtil.getName(type));
                }
                if (EntityGroupingUtil.isNPC(type)) {
                    npcs.add(EntityGroupingUtil.getName(type));
                }
                ++n2;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        animalNames = animals.toArray(new String[0]);
        monsterNames = monsters.toArray(new String[0]);
        npcNames = npcs.toArray(new String[0]);
    }

    public static boolean isMob(String name) {
        return EntityGroupingUtil.isAnimal(name) || EntityGroupingUtil.isMonster(name) || EntityGroupingUtil.isNPC(name);
    }

    public static boolean isNPC(String name) {
        return LogicUtil.contains(name.toLowerCase(Locale.ENGLISH), npcNames);
    }

    public static boolean isAnimal(String name) {
        return LogicUtil.contains(name.toLowerCase(Locale.ENGLISH), animalNames);
    }

    public static boolean isMonster(String name) {
        return LogicUtil.contains(name.toLowerCase(Locale.ENGLISH), monsterNames);
    }

    public static boolean isMob(Entity entity) {
        return EntityGroupingUtil.isMob(entity.getClass());
    }

    public static boolean isMob(EntityType entityType) {
        return EntityGroupingUtil.isMob(entityType.getEntityClass());
    }

    public static boolean isMob(Class<? extends Entity> entityClass) {
        return EntityGroupingUtil.isAnimal(entityClass) || EntityGroupingUtil.isMonster(entityClass);
    }

    public static boolean isNPC(Entity entity) {
        return EntityGroupingUtil.isNPC(entity.getClass());
    }

    public static boolean isNPC(EntityType entityType) {
        return EntityGroupingUtil.isNPC(entityType.getEntityClass());
    }

    public static boolean isNPC(Class<? extends Entity> entityClass) {
        return entityClass != null && NPC.class.isAssignableFrom(entityClass);
    }

    public static boolean isAnimal(Entity entity) {
        return EntityGroupingUtil.isAnimal(entity.getClass());
    }

    public static boolean isAnimal(EntityType entityType) {
        return EntityGroupingUtil.isAnimal(entityType.getEntityClass());
    }

    public static boolean isAnimal(Class<? extends Entity> entityClass) {
        return entityClass != null && (Animals.class.isAssignableFrom(entityClass) || Squid.class.isAssignableFrom(entityClass));
    }

    public static boolean isMonster(Entity entity) {
        return EntityGroupingUtil.isMonster(entity.getClass());
    }

    public static boolean isMonster(EntityType entityType) {
        return EntityGroupingUtil.isMonster(entityType.getEntityClass());
    }

    public static boolean isMonster(Class<? extends Entity> entityClass) {
        return entityClass != null && (Monster.class.isAssignableFrom(entityClass) || Slime.class.isAssignableFrom(entityClass));
    }

    public static String getName(Entity entity) {
        if (entity == null) {
            return "";
        }
        if (entity instanceof Item) {
            Material mat = ((Item)entity).getItemStack().getType();
            if (mat == null || mat == Material.AIR) {
                return "item";
            }
            return "item" + mat.toString().toLowerCase(Locale.ENGLISH);
        }
        if (entity instanceof FallingBlock) {
            Material mat = ((FallingBlock)entity).getMaterial();
            if (mat == null || mat == Material.AIR) {
                return "fallingblock";
            }
            return "falling" + mat.toString().toLowerCase(Locale.ENGLISH);
        }
        return EntityGroupingUtil.getName(entity.getClass());
    }

    public static String getName(Class<? extends Entity> entityClass) {
        if (entityClass == null) {
            return "";
        }
        EntityType[] entityTypeArray = EntityType.values();
        int n = entityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntityType type = entityTypeArray[n2];
            Class typeEntityClass = type.getEntityClass();
            if (typeEntityClass != null && typeEntityClass.isInstance(entityClass)) {
                return EntityGroupingUtil.getName(type);
            }
            ++n2;
        }
        return entityClass.getSimpleName();
    }

    public static String getName(EntityType type) {
        if (type == EntityType.OCELOT) {
            return "ocelot";
        }
        return type.getName().toLowerCase(Locale.ENGLISH);
    }
}

