/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.utils;

import com.bergerkiller.bukkit.common.utils.CommonUtil;
import com.bergerkiller.bukkit.common.utils.StringUtil;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class DebugUtil {
    public static void randomizeBlock(Block block) {
        DebugUtil.randomizeBlock(block, Material.STONE, Material.DIRT, Material.GRASS, Material.WOOD, Material.LOG, Material.IRON_ORE, Material.IRON_BLOCK, Material.GOLD_BLOCK, Material.DIAMOND_BLOCK);
    }

    public static void randomizeBlock(Block block, Material ... materials) {
        Material mat;
        do {
            mat = materials[(int)(Math.random() * (double)materials.length)];
        } while (block.getTypeId() == mat.getId());
        block.setType(mat);
    }

    public static String formatBlock(Block block) {
        return DebugUtil.formatBlock(block, "#world [#x, #y, #z] #type");
    }

    public static String formatBlock(Block block, String format) {
        StringBuilder buffer = new StringBuilder(format);
        StringUtil.replaceAll(buffer, "#x", Integer.toString(block.getX()));
        StringUtil.replaceAll(buffer, "#y", Integer.toString(block.getY()));
        StringUtil.replaceAll(buffer, "#z", Integer.toString(block.getZ()));
        StringUtil.replaceAll(buffer, "#world", block.getWorld().getName());
        StringUtil.replaceAll(buffer, "#typeid", Integer.toString(block.getTypeId()));
        StringUtil.replaceAll(buffer, "#type", block.getType().toString());
        return buffer.toString();
    }

    public static void heartbeat() {
        CommonUtil.broadcast("HEARTBEAT: " + System.currentTimeMillis());
    }
}

