/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.utils;

import com.bergerkiller.bukkit.common.Common;
import com.bergerkiller.bukkit.common.internal.CommonPlugin;
import com.bergerkiller.bukkit.common.utils.LogicUtil;
import com.bergerkiller.bukkit.common.utils.NativeUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import net.minecraft.server.v1_4_R1.DedicatedPlayerList;
import net.minecraft.server.v1_4_R1.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_4_R1.CraftServer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;

public class CommonUtil {
    public static final int VIEW = Bukkit.getServer().getViewDistance();
    public static final int VIEWWIDTH = VIEW + VIEW + 1;
    public static final int CHUNKAREA = VIEWWIDTH * VIEWWIDTH;
    public static final int BLOCKVIEW = 32 + (VIEW << 4);
    public static final Thread MAIN_THREAD = Thread.currentThread();

    public static void sendMessage(Object sender, Object message) {
        String msg;
        if (message != null && (msg = message.toString()).length() > 0 && sender instanceof CommandSender) {
            if (!(sender instanceof Player)) {
                message = ChatColor.stripColor((String)msg);
            }
            String[] stringArray = msg.split("\n", -1);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                ((CommandSender)sender).sendMessage(line);
                ++n2;
            }
        }
    }

    public static void sendListMessage(Object sender, String delimiter, Object[] items) {
        String msgpart = null;
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object oitem = objectArray[n2];
            String item = oitem.toString();
            if (msgpart == null || msgpart.length() + item.length() < 70) {
                msgpart = msgpart == null ? item : String.valueOf(msgpart) + ChatColor.WHITE + delimiter + item;
            } else {
                CommonUtil.sendMessage(sender, msgpart);
                msgpart = item;
            }
            ++n2;
        }
        CommonUtil.sendMessage(sender, msgpart);
    }

    public static <T extends Event> T callEvent(T event) {
        Bukkit.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static boolean hasHandlers(HandlerList handlerList) {
        return handlerList.getRegisteredListeners().length > 0;
    }

    public static MinecraftServer getMCServer() {
        return CommonUtil.getCraftServer().getServer();
    }

    public static CraftServer getCraftServer() {
        return (CraftServer)Bukkit.getServer();
    }

    public static DedicatedPlayerList getServerConfig() {
        return CommonUtil.getCraftServer().getHandle();
    }

    public static <T> void shuffle(T[] array) {
        int i = 1;
        while (i < array.length) {
            int random = (int)(Math.random() * (double)i);
            T temp = array[i - 1];
            array[i - 1] = array[random];
            array[random] = temp;
            ++i;
        }
    }

    public static Set addAllToSet(Set to, Set from) {
        for (Object i : from) {
            to.add(i);
        }
        return to;
    }

    public static Collection<Player> getOnlinePlayers() {
        return NativeUtil.getPlayers(CommonUtil.getServerConfig().players);
    }

    public static boolean hasPermission(CommandSender sender, String permissionNode) {
        return CommonPlugin.getInstance().hasPermission(sender, permissionNode);
    }

    public static StackTraceElement[] filterStackTrace(StackTraceElement[] elements, String className, String methodName) {
        ArrayList<StackTraceElement> rval = new ArrayList<StackTraceElement>(elements.length - 1);
        StackTraceElement[] stackTraceElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement elem = stackTraceElementArray[n2];
            if (elem.getClassName().equals(className) && elem.getMethodName().equals(methodName)) break;
            rval.add(elem);
            ++n2;
        }
        return rval.toArray(new StackTraceElement[0]);
    }

    public static <T extends Throwable> T filterStackTrace(T error, String className, String methodName) {
        error.setStackTrace(CommonUtil.filterStackTrace(error.getStackTrace(), className, methodName));
        return error;
    }

    public static StackTraceElement[] filterStackTrace(StackTraceElement[] elements) {
        StackTraceElement[] currStack = Thread.currentThread().getStackTrace();
        int i = 1;
        while (i < currStack.length) {
            if (!currStack[i].getClassName().equals(CommonUtil.class.getName()) || !currStack[i].getMethodName().equals("filterStackTrace")) {
                return CommonUtil.filterStackTrace(elements, currStack[i + 1].getClassName(), currStack[i + 1].getMethodName());
            }
            ++i;
        }
        return elements;
    }

    public static <T extends Throwable> T filterStackTrace(T error) {
        error.setStackTrace(CommonUtil.filterStackTrace(error.getStackTrace()));
        return error;
    }

    public static <T> T tryCast(Object object, Class<T> type) {
        try {
            return type.cast(object);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public static void nextTick(Runnable runnable) {
        CommonPlugin.getInstance().nextTick(runnable);
    }

    public static void broadcast(Object message) {
        if (message != null) {
            for (Player player : CommonUtil.getOnlinePlayers()) {
                player.sendMessage(message.toString());
            }
        }
    }

    public static Plugin[] getPlugins() {
        return Bukkit.getServer().getPluginManager().getPlugins();
    }

    public static Plugin getPlugin(String name) {
        return Bukkit.getServer().getPluginManager().getPlugin(name);
    }

    public static Class<?> getClass(String path) {
        try {
            return Class.forName(path);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Class<?> getNMSClass(String name) {
        return CommonUtil.getClass(String.valueOf(Common.NMS_ROOT) + "." + name);
    }

    public static Class<?> getCBClass(String name) {
        return CommonUtil.getClass(String.valueOf(Common.CB_ROOT) + "." + name);
    }

    public static <T> T[] getClassConstants(Class<T> theClass) {
        if (theClass.isEnum()) {
            return theClass.getEnumConstants();
        }
        try {
            Field[] declaredFields = theClass.getDeclaredFields();
            ArrayList<Object> constants = new ArrayList<Object>(declaredFields.length);
            Field[] fieldArray = declaredFields;
            int n = declaredFields.length;
            int n2 = 0;
            while (n2 < n) {
                Object constant;
                Field field = fieldArray[n2];
                if (Modifier.isStatic(field.getModifiers()) && theClass.isAssignableFrom(field.getType()) && (constant = field.get(null)) != null) {
                    constants.add(constant);
                }
                ++n2;
            }
            return LogicUtil.toArray(constants, theClass);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return LogicUtil.createArray(theClass, 0);
        }
    }
}

