/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.utils;

import com.bergerkiller.bukkit.common.Common;
import com.bergerkiller.bukkit.common.internal.CommonPlugin;
import com.bergerkiller.bukkit.common.natives.NativeChunkEntitiesWrapper;
import com.bergerkiller.bukkit.common.natives.NativeChunkWrapper;
import com.bergerkiller.bukkit.common.reflection.classes.ChunkProviderServerRef;
import com.bergerkiller.bukkit.common.reflection.classes.ChunkRef;
import com.bergerkiller.bukkit.common.reflection.classes.ChunkSectionRef;
import com.bergerkiller.bukkit.common.utils.CommonUtil;
import com.bergerkiller.bukkit.common.utils.NativeUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import net.minecraft.server.v1_4_R1.Chunk;
import net.minecraft.server.v1_4_R1.ChunkSection;
import net.minecraft.server.v1_4_R1.World;
import net.minecraft.server.v1_4_R1.WorldServer;
import org.bukkit.craftbukkit.v1_4_R1.util.LongHash;
import org.bukkit.craftbukkit.v1_4_R1.util.LongHashSet;
import org.bukkit.craftbukkit.v1_4_R1.util.LongObjectHashMap;
import org.bukkit.entity.Entity;

public class ChunkUtil {
    private static boolean canUseLongObjectHashMap = CommonUtil.getClass(String.valueOf(Common.CB_ROOT) + ".util.LongObjectHashMap") != null;
    private static boolean canUseLongHashSet = CommonUtil.getClass(String.valueOf(Common.CB_ROOT) + ".util.LongHashSet") != null;

    public static int getHeight(org.bukkit.Chunk chunk, int x, int z) {
        return ChunkRef.getHeight(NativeUtil.getNative(chunk), x, z);
    }

    public static int getBlockLight(org.bukkit.Chunk chunk, int x, int y, int z) {
        return ChunkRef.getBlockLight(NativeUtil.getNative(chunk), x, y, z);
    }

    public static int getSkyLight(org.bukkit.Chunk chunk, int x, int y, int z) {
        return ChunkRef.getSkyLight(NativeUtil.getNative(chunk), x, y, z);
    }

    public static int getBlockData(org.bukkit.Chunk chunk, int x, int y, int z) {
        return ChunkRef.getData(NativeUtil.getNative(chunk), x, y, z);
    }

    public static int getBlockTypeId(org.bukkit.Chunk chunk, int x, int y, int z) {
        return ChunkRef.getTypeId(NativeUtil.getNative(chunk), x, y, z);
    }

    public static void setBlockFast(org.bukkit.Chunk chunk, int x, int y, int z, int typeId, int data) {
        int secIndex;
        if (y < 0 || y >= chunk.getWorld().getMaxHeight()) {
            return;
        }
        ChunkSection[] sections = ChunkRef.getSections(NativeUtil.getNative(chunk));
        ChunkSection section = sections[secIndex = y >> 4];
        if (section == null) {
            section = sections[secIndex] = new ChunkSection(y >> 4 << 4, !((World)chunk.getWorld()).worldProvider.f);
        }
        ChunkSectionRef.setTypeId(section, x, y, z, typeId);
        ChunkSectionRef.setData(section, x, y, z, data);
    }

    public static boolean setBlock(org.bukkit.Chunk chunk, int x, int y, int z, int typeId, int data) {
        boolean result = y >= 0 && y <= chunk.getWorld().getMaxHeight();
        WorldServer world = NativeUtil.getNative(chunk.getWorld());
        if (result) {
            result = ChunkRef.setBlock(NativeUtil.getNative(chunk), x, y, z, typeId, data);
            world.methodProfiler.a("checkLight");
            world.z(x, y, z);
            world.methodProfiler.b();
        }
        if (result) {
            world.applyPhysics(x, y, z, typeId);
        }
        return result;
    }

    public static Collection<Entity> getEntities(org.bukkit.Chunk chunk) {
        return new NativeChunkEntitiesWrapper(chunk);
    }

    public static Collection<org.bukkit.Chunk> getChunks(org.bukkit.World world) {
        Object chunks;
        if (canUseLongObjectHashMap && (chunks = ChunkProviderServerRef.chunks.get(NativeUtil.getNative((org.bukkit.World)world).chunkProviderServer)) != null) {
            try {
                if (canUseLongObjectHashMap && chunks instanceof LongObjectHashMap) {
                    return new NativeChunkWrapper(((LongObjectHashMap)chunks).values());
                }
            }
            catch (Throwable t) {
                canUseLongObjectHashMap = false;
                CommonPlugin.getInstance().log(Level.WARNING, "Failed to access chunks using CraftBukkit's long object hashmap, support disabled");
                CommonUtil.filterStackTrace(t).printStackTrace();
            }
        }
        return Arrays.asList(world.getLoadedChunks());
    }

    public static org.bukkit.Chunk getChunk(org.bukkit.World world, int x, int z) {
        long key = LongHash.toLong((int)x, (int)z);
        Object chunks = ChunkProviderServerRef.chunks.get(NativeUtil.getNative((org.bukkit.World)world).chunkProviderServer);
        if (chunks != null && canUseLongObjectHashMap && chunks instanceof LongObjectHashMap) {
            try {
                return NativeUtil.getChunk((Chunk)((LongObjectHashMap)chunks).get(key));
            }
            catch (Throwable t) {
                canUseLongObjectHashMap = false;
                CommonPlugin.getInstance().log(Level.WARNING, "Failed to access chunks using CraftBukkit's long object hashmap, support disabled");
                CommonUtil.filterStackTrace(t).printStackTrace();
            }
        }
        if (world.isChunkLoaded(x, z)) {
            return world.getChunkAt(x, z);
        }
        return null;
    }

    public static void setChunk(org.bukkit.World world, int x, int z, org.bukkit.Chunk chunk) {
        Object chunks;
        if (canUseLongObjectHashMap && (chunks = ChunkProviderServerRef.chunks.get(NativeUtil.getNative((org.bukkit.World)world).chunkProviderServer)) != null) {
            long key = LongHash.toLong((int)x, (int)z);
            try {
                if (canUseLongObjectHashMap && chunks instanceof LongObjectHashMap) {
                    ((LongObjectHashMap)chunks).put(key, (Object)NativeUtil.getNative(chunk));
                    return;
                }
            }
            catch (Throwable t) {
                canUseLongObjectHashMap = false;
                CommonPlugin.getInstance().log(Level.WARNING, "Failed to access chunks using CraftBukkit's long object hashmap, support disabled");
                CommonUtil.filterStackTrace(t).printStackTrace();
            }
        }
        throw new RuntimeException("Failed to set chunk using a known method");
    }

    public static void saveChunk(org.bukkit.Chunk chunk) {
        NativeUtil.getNative((org.bukkit.World)chunk.getWorld()).chunkProviderServer.saveChunk(NativeUtil.getNative(chunk));
    }

    public static void setChunkUnloading(org.bukkit.World world, int x, int z, boolean unload) {
        Object unloadQueue;
        if (canUseLongHashSet && (unloadQueue = ChunkProviderServerRef.unloadQueue.get(NativeUtil.getNative((org.bukkit.World)world).chunkProviderServer)) != null) {
            try {
                if (canUseLongHashSet && unloadQueue instanceof LongHashSet) {
                    if (unload) {
                        ((LongHashSet)unloadQueue).add(x, z);
                    } else {
                        ((LongHashSet)unloadQueue).remove(x, z);
                    }
                    return;
                }
            }
            catch (Throwable t) {
                canUseLongHashSet = false;
                CommonPlugin.getInstance().log(Level.WARNING, "Failed to access chunks using CraftBukkit's long object hashmap, support disabled");
                CommonUtil.filterStackTrace(t).printStackTrace();
            }
        }
        throw new RuntimeException("Failed to set unload queue using a known method");
    }
}

