/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.utils;

import com.bergerkiller.bukkit.common.reflection.classes.TileEntityRef;
import com.bergerkiller.bukkit.common.utils.CommonUtil;
import com.bergerkiller.bukkit.common.utils.FaceUtil;
import com.bergerkiller.bukkit.common.utils.MaterialUtil;
import com.bergerkiller.bukkit.common.utils.NativeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import net.minecraft.server.v1_4_R1.ChunkCoordinates;
import net.minecraft.server.v1_4_R1.Packet;
import net.minecraft.server.v1_4_R1.TileEntity;
import net.minecraft.server.v1_4_R1.TileEntityChest;
import net.minecraft.server.v1_4_R1.TileEntityDispenser;
import net.minecraft.server.v1_4_R1.TileEntityFurnace;
import net.minecraft.server.v1_4_R1.TileEntitySign;
import net.minecraft.server.v1_4_R1.World;
import net.minecraft.server.v1_4_R1.WorldServer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.Dispenser;
import org.bukkit.block.Furnace;
import org.bukkit.block.Sign;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.material.Attachable;
import org.bukkit.material.Directional;
import org.bukkit.material.MaterialData;
import org.bukkit.material.Rails;

public class BlockUtil
extends MaterialUtil {
    private static final LinkedHashSet<TileEntity> tilebuff = new LinkedHashSet();

    public static MaterialData getData(Block block) {
        return block.getType().getNewData(block.getData());
    }

    public static <T> T getData(Block block, Class<T> type) {
        try {
            return type.cast(BlockUtil.getData(block));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static int getManhattanDistance(Location b1, Location b2, boolean checkY) {
        int d = Math.abs(b1.getBlockX() - b2.getBlockX());
        d += Math.abs(b1.getBlockZ() - b2.getBlockZ());
        if (checkY) {
            d += Math.abs(b1.getBlockY() - b2.getBlockY());
        }
        return d;
    }

    public static int getManhattanDistance(Block b1, Block b2, boolean checkY) {
        int d = Math.abs(b1.getX() - b2.getX());
        d += Math.abs(b1.getZ() - b2.getZ());
        if (checkY) {
            d += Math.abs(b1.getY() - b2.getY());
        }
        return d;
    }

    public static boolean equals(Block block1, Block block2) {
        if (block1 == null || block2 == null) {
            return false;
        }
        if (block1 == block2) {
            return true;
        }
        return block1.getX() == block2.getX() && block1.getZ() == block2.getZ() && block1.getY() == block2.getY() && block1.getWorld() == block2.getWorld();
    }

    public static Block[] getRelative(Block main, BlockFace ... faces) {
        if (main == null) {
            return new Block[0];
        }
        Block[] rval = new Block[faces.length];
        int i = 0;
        while (i < rval.length) {
            rval[i] = main.getRelative(faces[i]);
            ++i;
        }
        return rval;
    }

    public static ChunkCoordinates getCoordinates(Block block) {
        return new ChunkCoordinates(block.getX(), block.getY(), block.getZ());
    }

    public static Block getBlock(org.bukkit.World world, ChunkCoordinates at) {
        return world.getBlockAt(at.x, at.y, at.z);
    }

    public static Block getBlock(TileEntity tileEntity) {
        return tileEntity.world.getWorld().getBlockAt(tileEntity.x, tileEntity.y, tileEntity.z);
    }

    public static BlockFace getAttachedFace(Block attachable) {
        Attachable data = BlockUtil.getData(attachable, Attachable.class);
        return data == null ? BlockFace.DOWN : data.getAttachedFace();
    }

    public static Block getAttachedBlock(Block attachable) {
        return attachable.getRelative(BlockUtil.getAttachedFace(attachable));
    }

    public static BlockFace getFacing(Block directional) {
        Directional data = BlockUtil.getData(directional, Directional.class);
        return data == null ? BlockFace.NORTH : data.getFacing();
    }

    public static void setFacing(Block block, BlockFace facing) {
        MaterialData data = BlockUtil.getData(block);
        if (data != null && data instanceof Directional) {
            ((Directional)data).setFacingDirection(facing);
            block.setData(data.getData(), true);
        }
    }

    public static void setLeversAroundBlock(Block block, boolean down) {
        BlockFace[] blockFaceArray = FaceUtil.ATTACHEDFACES;
        int n = FaceUtil.ATTACHEDFACES.length;
        int n2 = 0;
        while (n2 < n) {
            BlockFace dir = blockFaceArray[n2];
            Block b = block.getRelative(dir);
            if (BlockUtil.isType(b, Material.LEVER) && BlockUtil.getAttachedFace(b) == dir.getOppositeFace()) {
                BlockUtil.setLever(b, down);
            }
            ++n2;
        }
    }

    public static boolean isLeverDown(Block lever) {
        byte dat = lever.getData();
        return dat == (dat | 8);
    }

    public static void setLever(Block lever, boolean down) {
        byte data;
        int newData = down ? data | 8 : data & 7;
        if (newData != (data = lever.getData())) {
            int old = !down ? 1 : 0;
            int current = down ? 1 : 0;
            BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(lever, old, current);
            CommonUtil.callEvent(eventRedstone);
            if (eventRedstone.getNewCurrent() > 0 != down) {
                return;
            }
            lever.setData((byte)newData, true);
            BlockUtil.applyPhysics(BlockUtil.getAttachedBlock(lever), Material.LEVER);
        }
    }

    public static void dropNaturally(Block block, float yield) {
        net.minecraft.server.v1_4_R1.Block b = net.minecraft.server.v1_4_R1.Block.byId[block.getTypeId()];
        if (b != null) {
            b.dropNaturally((World)NativeUtil.getNative(block.getWorld()), block.getX(), block.getY(), block.getZ(), (int)block.getData(), yield, 0);
        }
    }

    public static void applyPhysics(Block block, Material callertype) {
        BlockUtil.applyPhysics(block, callertype.getId());
    }

    public static void applyPhysics(Block block, int callertypeid) {
        NativeUtil.getNative(block.getWorld()).applyPhysics(block.getX(), block.getY(), block.getZ(), callertypeid);
    }

    public static void setRails(Block rails, BlockFace from, BlockFace to) {
        BlockUtil.setRails(rails, FaceUtil.combine(from, to).getOppositeFace());
    }

    public static void setRails(Block rails, BlockFace direction) {
        Material type = rails.getType();
        if (type == Material.RAILS) {
            BlockFace railsDirection = direction == BlockFace.NORTH ? BlockFace.SOUTH : (direction == BlockFace.EAST ? BlockFace.WEST : direction);
            byte olddata = rails.getData();
            Rails r = (Rails)type.getNewData(olddata);
            r.setDirection(railsDirection, r.isOnSlope());
            byte newdata = r.getData();
            if (olddata != newdata) {
                rails.setData(newdata);
            }
        }
    }

    public static <T extends BlockState> T getState(Block block, Class<T> type) {
        return (T)((BlockState)CommonUtil.tryCast(block.getState(), type));
    }

    public static Rails getRails(Block railsblock) {
        return BlockUtil.getData(railsblock, Rails.class);
    }

    public static Sign getSign(Block signblock) {
        return BlockUtil.getState(signblock, Sign.class);
    }

    public static Chest getChest(Block chestblock) {
        return BlockUtil.getState(chestblock, Chest.class);
    }

    public static <T extends TileEntity> T getTile(Block block, Class<T> type) {
        try {
            return (T)((TileEntity)type.cast(NativeUtil.getNative(block.getWorld()).getTileEntity(block.getX(), block.getY(), block.getZ())));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static <T extends TileEntity> T getTile(BlockState block, Class<T> type) {
        try {
            return (T)((TileEntity)type.cast(NativeUtil.getNative(block.getWorld()).getTileEntity(block.getX(), block.getY(), block.getZ())));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static TileEntitySign getTile(Sign sign) {
        return BlockUtil.getTile((BlockState)sign, TileEntitySign.class);
    }

    public static TileEntityFurnace getTile(Furnace furnace) {
        return BlockUtil.getTile((BlockState)furnace, TileEntityFurnace.class);
    }

    public static TileEntityChest getTile(Chest chest) {
        return BlockUtil.getTile((BlockState)chest, TileEntityChest.class);
    }

    public static TileEntityDispenser getTile(Dispenser dispenser) {
        return BlockUtil.getTile((BlockState)dispenser, TileEntityDispenser.class);
    }

    public static TileEntitySign getTileSign(Block block) {
        return BlockUtil.getTile(block, TileEntitySign.class);
    }

    public static TileEntityChest getTileChest(Block block) {
        return BlockUtil.getTile(block, TileEntityChest.class);
    }

    public static TileEntityFurnace getTileFurnace(Block block) {
        return BlockUtil.getTile(block, TileEntityFurnace.class);
    }

    public static TileEntityDispenser getTileDispenser(Block block) {
        return BlockUtil.getTile(block, TileEntityDispenser.class);
    }

    public static Collection<BlockState> getBlockStates(Block middle) {
        return BlockUtil.getBlockStates(middle, 0, 0, 0);
    }

    public static Collection<BlockState> getBlockStates(Block middle, int radius) {
        return BlockUtil.getBlockStates(middle, radius, radius, radius);
    }

    public static Collection<BlockState> getBlockStates(Block middle, int radiusX, int radiusY, int radiusZ) {
        return BlockUtil.getBlockStates(middle.getWorld(), middle.getX(), middle.getY(), middle.getZ(), radiusX, radiusY, radiusZ);
    }

    public static Collection<BlockState> getBlockStates(org.bukkit.World world, int x, int y, int z, int radiusX, int radiusY, int radiusZ) {
        WorldServer nWorld = NativeUtil.getNative(world);
        if (radiusX == 0 && radiusY == 0 && radiusZ == 0) {
            TileEntity tile = nWorld.getTileEntity(x, y, z);
            if (tile != null) {
                BlockUtil.offerTile(tile);
            }
        } else {
            int xMin = x - radiusX;
            int yMin = y - radiusY;
            int zMin = z - radiusZ;
            int xMax = x + radiusX;
            int yMax = y + radiusY;
            int zMax = z + radiusZ;
            for (TileEntity tile : nWorld.tileEntityList) {
                if (tile.x < xMin || tile.y < yMin || tile.z < zMin || tile.x > xMax || tile.y > yMax || tile.z > zMax || (tile = nWorld.getTileEntity(tile.x, tile.y, tile.z)) == null) continue;
                BlockUtil.offerTile(tile);
            }
        }
        ArrayList<BlockState> blocks = new ArrayList<BlockState>(tilebuff.size());
        for (TileEntity tile : tilebuff) {
            BlockState state = BlockUtil.getBlock(tile).getState();
            if (state == null) continue;
            blocks.add(state);
        }
        tilebuff.clear();
        return blocks;
    }

    public static org.bukkit.World getWorld(TileEntity tile) {
        return TileEntityRef.world.get(tile).getWorld();
    }

    public static Packet getUpdatePacket(TileEntity tile) {
        return tile.getUpdatePacket();
    }

    private static void offerTile(TileEntity tile) {
        if (tile instanceof TileEntityChest) {
            WorldServer world = NativeUtil.getNative(BlockUtil.getWorld(tile));
            BlockFace[] blockFaceArray = FaceUtil.AXIS;
            int n = FaceUtil.AXIS.length;
            int n2 = 0;
            while (n2 < n) {
                TileEntity next;
                int tmpz;
                BlockFace sface = blockFaceArray[n2];
                int tmpx = tile.x + sface.getModX();
                if (world.getTypeId(tmpx, tile.y, tmpz = tile.z + sface.getModZ()) == Material.CHEST.getId() && (next = world.getTileEntity(tmpx, tile.y, tmpz)) != null && next instanceof TileEntityChest) {
                    if (sface == BlockFace.WEST || sface == BlockFace.SOUTH) {
                        tilebuff.add(next);
                        tilebuff.add(tile);
                    } else {
                        tilebuff.add(tile);
                        tilebuff.add(next);
                    }
                    return;
                }
                ++n2;
            }
        }
        tilebuff.add(tile);
    }

    public static void breakBlock(Block block) {
        BlockUtil.dropNaturally(block, 20.0f);
        block.setTypeId(0);
    }
}

