/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.reflection.classes;

import com.bergerkiller.bukkit.common.reflection.ClassTemplate;
import com.bergerkiller.bukkit.common.reflection.FieldAccessor;
import com.bergerkiller.bukkit.common.reflection.MethodAccessor;
import com.bergerkiller.bukkit.common.reflection.NMSClassTemplate;
import com.bergerkiller.bukkit.common.reflection.SafeField;
import com.bergerkiller.bukkit.common.utils.CommonUtil;
import net.minecraft.server.v1_4_R1.Chunk;
import net.minecraft.server.v1_4_R1.ChunkSection;
import net.minecraft.server.v1_4_R1.EnumSkyBlock;

public class ChunkRef {
    public static final int XZ_MASK = 15;
    public static final int Y_MASK = 255;
    public static final ClassTemplate<Object> TEMPLATE = new NMSClassTemplate("Chunk");
    public static final FieldAccessor<Integer> x = TEMPLATE.getField("x");
    public static final FieldAccessor<Integer> z = TEMPLATE.getField("z");
    public static final MethodAccessor<byte[]> biomeData = TEMPLATE.getMethod("m", new Class[0]);
    public static final MethodAccessor<Object[]> sections = TEMPLATE.getMethod("i", new Class[0]);
    public static final FieldAccessor<Object> world = TEMPLATE.getField("world");
    public static final FieldAccessor<Object> worldProvider = new SafeField<Object>(CommonUtil.getNMSClass("World"), "worldProvider");
    public static final FieldAccessor<Boolean> hasSkyLight = new SafeField<Boolean>(CommonUtil.getNMSClass("WorldProvider"), "f");

    public static ChunkSection[] getSections(Chunk chunk) {
        return chunk.i();
    }

    public static int getTopSectionY(Chunk chunk) {
        return chunk.h();
    }

    public static int getHeight(Chunk chunk, int x, int z) {
        return chunk.b(x & 0xF, z & 0xF);
    }

    public static int getBlockLight(Chunk chunk, int x, int y, int z) {
        return ChunkRef.getBrightness(chunk, x, y, z, EnumSkyBlock.BLOCK);
    }

    public static int getSkyLight(Chunk chunk, int x, int y, int z) {
        return ChunkRef.getBrightness(chunk, x, y, z, EnumSkyBlock.SKY);
    }

    private static int getBrightness(Chunk chunk, int x, int y, int z, EnumSkyBlock mode) {
        if (y < 0) {
            return 0;
        }
        if (y >= chunk.world.getWorld().getMaxHeight()) {
            return mode.c;
        }
        return chunk.getBrightness(mode, x & 0xF, y, z & 0xF);
    }

    public static boolean setBlock(Chunk chunk, int x, int y, int z, int typeId, int data) {
        return chunk.a(x & 0xF, y, z & 0xF, typeId, data);
    }

    public static int getData(Chunk chunk, int x, int y, int z) {
        return chunk.getData(x & 0xF, y, z & 0xF);
    }

    public static int getTypeId(Chunk chunk, int x, int y, int z) {
        return chunk.getTypeId(x & 0xF, y, z & 0xF);
    }
}

