/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.reflection;

import com.bergerkiller.bukkit.common.internal.CommonPlugin;
import com.bergerkiller.bukkit.common.reflection.MethodAccessor;
import com.bergerkiller.bukkit.common.utils.LogicUtil;
import com.bergerkiller.bukkit.common.utils.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import org.bukkit.Bukkit;

public class SafeMethod<T>
implements MethodAccessor<T> {
    private Method method;

    public SafeMethod(String methodPath, Class<?> ... parameterTypes) {
        if (LogicUtil.nullOrEmpty(methodPath) || !methodPath.contains(".")) {
            Bukkit.getLogger().log(Level.SEVERE, "Method path contains no class: " + methodPath);
            return;
        }
        try {
            String className = StringUtil.getBefore(methodPath, ".");
            String methodName = methodPath.substring(className.length() + 1);
            this.load(Class.forName(className), methodName, parameterTypes);
        }
        catch (Throwable t) {
            System.out.println("Failed to load method '" + methodPath + "':");
            t.printStackTrace();
        }
    }

    public SafeMethod(Object value, String name, Class<?> ... parameterTypes) {
        this.load(value == null ? null : value.getClass(), name, parameterTypes);
    }

    public SafeMethod(Class<?> source, String name, Class<?> ... parameterTypes) {
        this.load(source, name, parameterTypes);
    }

    private void load(Class<?> source, String name, Class<?> ... parameterTypes) {
        if (source == null) {
            new Exception("Can not load method '" + name + "' because the class is null!").printStackTrace();
            return;
        }
        for (Class<?> tmp = source; tmp != null; tmp = tmp.getSuperclass()) {
            try {
                this.method = tmp.getDeclaredMethod(name, parameterTypes);
                this.method.setAccessible(true);
                return;
            }
            catch (NoSuchMethodException ex) {
                continue;
            }
            catch (SecurityException ex) {
                new Exception("No permission to access method '" + name + "' in class file '" + source.getSimpleName() + "'").printStackTrace();
                return;
            }
        }
        name = String.valueOf(name) + "(";
        int i = 0;
        while (i < parameterTypes.length) {
            if (i > 0) {
                name = String.valueOf(name) + ", ";
            }
            name = String.valueOf(name) + parameterTypes[i].getSimpleName();
            ++i;
        }
        name = String.valueOf(name) + ")";
        CommonPlugin.getInstance().handleReflectionMissing("Method", name, source);
    }

    public String getName() {
        return this.method.getName();
    }

    @Override
    public boolean isValid() {
        return this.method != null;
    }

    @Override
    public T invoke(Object instance, Object ... args) {
        if (this.method != null) {
            try {
                return (T)this.method.invoke(instance, args);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

