/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.reflection;

import com.bergerkiller.bukkit.common.internal.CommonPlugin;
import com.bergerkiller.bukkit.common.reflection.FieldAccessor;
import com.bergerkiller.bukkit.common.utils.LogicUtil;
import com.bergerkiller.bukkit.common.utils.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import org.bukkit.Bukkit;

public class SafeField<T>
implements FieldAccessor<T> {
    private Field field;

    public SafeField(Field field) {
        if (!field.isAccessible()) {
            try {
                field.setAccessible(true);
            }
            catch (SecurityException ex) {
                ex.printStackTrace();
                field = null;
            }
        }
        this.field = field;
    }

    public SafeField(String fieldPath) {
        if (LogicUtil.nullOrEmpty(fieldPath) || !fieldPath.contains(".")) {
            Bukkit.getLogger().log(Level.SEVERE, "Field path contains no class: " + fieldPath);
            return;
        }
        try {
            String className = StringUtil.getBefore(fieldPath, ".");
            String methodName = fieldPath.substring(className.length() + 1);
            this.load(Class.forName(className), methodName);
        }
        catch (Throwable t) {
            System.out.println("Failed to load field '" + fieldPath + "':");
            t.printStackTrace();
        }
    }

    public SafeField(Object value, String name) {
        this.load(value == null ? null : value.getClass(), name);
    }

    public SafeField(Class<?> source, String name) {
        this.load(source, name);
    }

    private void load(Class<?> source, String name) {
        if (source == null) {
            new Exception("Can not load field '" + name + "' because the class is null!").printStackTrace();
            return;
        }
        for (Class<?> tmp = source; tmp != null; tmp = tmp.getSuperclass()) {
            try {
                this.field = tmp.getDeclaredField(name);
                this.field.setAccessible(true);
                return;
            }
            catch (NoSuchFieldException ex) {
                continue;
            }
            catch (SecurityException ex) {
                new Exception("No permission to access field '" + name + "' in class file '" + source.getSimpleName() + "'").printStackTrace();
                return;
            }
        }
        CommonPlugin.getInstance().handleReflectionMissing("Field", name, source);
    }

    @Override
    public boolean isValid() {
        return this.field != null;
    }

    @Override
    public T transfer(Object from, Object to) {
        if (this.field == null) {
            return null;
        }
        T old = this.get(to);
        this.set(to, this.get(from));
        return old;
    }

    @Override
    public T get(Object object) {
        if (this.field == null) {
            return null;
        }
        try {
            return (T)this.field.get(object);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.field = null;
            return null;
        }
    }

    @Override
    public boolean set(Object object, T value) {
        if (this.field != null) {
            try {
                this.field.set(object, value);
                return true;
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.field = null;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder text = new StringBuilder(20);
        int mod = this.field.getModifiers();
        if (Modifier.isPublic(mod)) {
            text.append("public ");
        } else if (Modifier.isPrivate(mod)) {
            text.append("private ");
        } else if (Modifier.isProtected(mod)) {
            text.append("protected ");
        }
        if (Modifier.isStatic(mod)) {
            text.append("static ");
        }
        return text.append(this.field.getType().getName()).append(" ").append(this.field.getName()).toString();
    }

    public String getName() {
        return this.field.getName();
    }

    public Class<?> getType() {
        return this.field.getType();
    }

    public static <T> void set(Object source, String fieldname, T value) {
        new SafeField<T>(source, fieldname).set(source, value);
    }

    public static <T> void setStatic(Class<?> clazz, String fieldname, T value) {
        new SafeField<T>(clazz, fieldname).set(null, value);
    }

    public static <T> T get(Object source, String fieldname) {
        return new SafeField<T>(source, fieldname).get(source);
    }

    public static <T> T get(Class<?> clazz, String fieldname) {
        return new SafeField<T>(clazz, fieldname).get(null);
    }

    public static <T> SafeField<T> create(Class<?> type, String name) {
        return new SafeField<T>(type, name);
    }
}

