/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.reflection;

import java.lang.reflect.Constructor;

public class SafeConstructor<T> {
    private Constructor<T> constructor;

    public SafeConstructor(Class<T> type, Class<?> ... parameterTypes) {
        try {
            this.constructor = type.getConstructor(parameterTypes);
            this.constructor.setAccessible(true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public boolean isValid() {
        return this.constructor != null;
    }

    public T newInstance(Object ... parameters) {
        try {
            return this.constructor.newInstance(parameters);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

