/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.reflection;

import com.bergerkiller.bukkit.common.reflection.FieldAccessor;
import com.bergerkiller.bukkit.common.reflection.SafeConstructor;
import com.bergerkiller.bukkit.common.reflection.SafeField;
import com.bergerkiller.bukkit.common.reflection.SafeMethod;
import com.bergerkiller.bukkit.common.utils.CommonUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ClassTemplate<T> {
    private Class<T> type;
    private List<SafeField<?>> fields;

    public ClassTemplate() {
    }

    public ClassTemplate(Class<T> type) {
        this.setClass(type);
    }

    protected void setClass(Class<T> type) {
        this.type = type;
        this.fields = new ArrayList();
        if (this.type != null) {
            try {
                this.fillFields(type);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private void fillFields(Class<?> clazz) {
        if (clazz == null) {
            return;
        }
        Field[] declared = clazz.getDeclaredFields();
        ArrayList newFields = new ArrayList(declared.length);
        Field[] fieldArray = declared;
        int n = declared.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (!Modifier.isStatic(field.getModifiers())) {
                newFields.add(new SafeField(field));
            }
            ++n2;
        }
        this.fields.addAll(0, newFields);
        this.fillFields(clazz.getSuperclass());
    }

    public Class<T> getType() {
        return this.type;
    }

    public List<SafeField<?>> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public T newInstance() {
        try {
            return this.type.newInstance();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public boolean isInstance(Object object) {
        return this.type.isInstance(object);
    }

    public boolean isType(Object object) {
        return object != null && this.isType(object.getClass());
    }

    public boolean isType(Class<?> clazz) {
        return clazz != null && this.type.equals(clazz);
    }

    public void transfer(Object from, Object to) {
        for (FieldAccessor fieldAccessor : this.fields) {
            fieldAccessor.transfer(from, to);
        }
    }

    public boolean isValid() {
        return this.type != null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(500);
        builder.append("Class path: ").append(this.getType().getName()).append('\n');
        builder.append("Fields (").append(this.fields.size()).append("):");
        for (FieldAccessor fieldAccessor : this.fields) {
            builder.append("\n    ").append(fieldAccessor.toString());
        }
        return builder.toString();
    }

    public SafeConstructor<T> getConstructor(Class<?> ... parameterTypes) {
        return new SafeConstructor<T>(this.getType(), parameterTypes);
    }

    public <K> SafeField<K> getField(String name) {
        return new SafeField(this.getType(), name);
    }

    public <K> SafeMethod<K> getMethod(String name, Class<?> ... parameterTypes) {
        return new SafeMethod(this.getType(), name, parameterTypes);
    }

    public <K> K getStaticFieldValue(String name) {
        return (K)SafeField.get(this.getType(), name);
    }

    public <K> void setStaticFieldValue(String name, K value) {
        SafeField.setStatic(this.getType(), name, value);
    }

    public static ClassTemplate<?> create(String path) {
        return ClassTemplate.create(CommonUtil.getClass(path));
    }

    public static <T> ClassTemplate<T> create(T value) {
        return ClassTemplate.create(value.getClass());
    }

    public static <T> ClassTemplate<T> create(Class<T> clazz) {
        return new ClassTemplate<T>(clazz);
    }
}

