/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.protocol;

import com.bergerkiller.bukkit.common.protocol.PacketFields;
import com.bergerkiller.bukkit.common.reflection.ClassTemplate;
import com.bergerkiller.bukkit.common.reflection.SafeField;
import com.bergerkiller.bukkit.common.reflection.classes.DataWatcherRef;
import com.bergerkiller.bukkit.common.reflection.classes.IntHashMapRef;
import java.util.Arrays;
import java.util.List;

public enum PacketType {
    KEEP_ALIVE(0),
    OPEN_WINDOW(100),
    CLODE_WINDOW(101),
    WINDOW_CLICK(102),
    SET_SLOW(103),
    WINDOW_ITEMS(104),
    PROGRESS_BAR(105),
    TRANSACTION(106),
    SET_CREATIVE_SLOT(107),
    BUTTON_CLICK(108),
    FLYING(10),
    PLAYER_POSITION(11),
    PLAYER_LOOK(12),
    UPDATE_SIGN(130),
    ITEM_DATA(131),
    TILE_ENTITY_DATA(132),
    PLAYER_LOOK_MOVE(13),
    BLOCK_DIG(14),
    PLACE(15),
    BLOCK_ITEM_SWITCH(16),
    ENTITY_LOCATION_ACTION(17),
    ANIMATION(18),
    ENTITY_ACTION(19),
    LOGIN(1),
    STATISTIC(200),
    PLAYER_INFO(201),
    ABILITIES(202),
    TAB_COMPLETE(203),
    CLIENT_INFO(204),
    CLIENT_COMMAND(205),
    NAMED_ENTITY_SPAWN(20),
    COLLECT(22),
    VEHICLE_SPAWN(23),
    MOB_SPAWN(24),
    CUSTOM_PAYLOAD(250),
    KEY_RESPONSE(252),
    KEY_REQUEST(253),
    GET_INFO(254),
    DISCONNECT(255),
    ENTITY_PAINTING(25),
    ADD_EXP_ORB(26),
    ENTITY_VELOCITY(28),
    DESTROY_ENTITY(29),
    HANDSHAKE(2),
    ENTITY(30),
    ENTITY_MOVE(31),
    ENTITY_LOOK(32),
    ETITY_MOVE_LOOK(33),
    ENTITY_TELEPORT(34),
    ENTITY_HEAD_ROTATION(35),
    ENTITY_STATUS(38),
    ATTACH_ENTITY(39),
    CHAT(3),
    ENTITY_METADATA(40),
    MOB_EFFECT(41),
    REMOVE_MOB_EFFECT(42),
    SET_EXP(43),
    UPDATE_TIME(4),
    MAP_CHUNK(51),
    MULTI_BLOCK_CHANGE(52),
    BLOCK_CHANGE(53),
    PLAY_NOTEBLOCK(54),
    BLOCK_BREAK_ANIMATION(55),
    MAP_CHUNK_BULK(56),
    ENTITY_EQUIPMENT(5),
    EXPLOSION(60),
    WOLRD_EVENT(61),
    NAMED_SOUND_EFFECT(62),
    SPAWN_POSITION(6),
    BED(70),
    WEATHER(71),
    USE_ENTITY(7),
    UPDATE_HEALTH(8),
    RESPAWN(9),
    UNKNOWN(-1);

    private final int id;
    private final ClassTemplate<?> template;
    private final String[] fieldNames;
    private final String dataWatcherField;
    private static final PacketType[] byId;

    static {
        byId = new PacketType[256];
        Arrays.fill((Object[])byId, (Object)UNKNOWN);
        PacketType[] packetTypeArray = PacketType.values();
        int n = packetTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PacketType type = packetTypeArray[n2];
            if (type != UNKNOWN) {
                PacketType.byId[type.getId()] = type;
            }
            ++n2;
        }
    }

    private PacketType(int id) {
        this.id = id;
        Class type = (Class)IntHashMapRef.get(PacketFields.DEFAULT.getStaticFieldValue("l"), id);
        if (type == null) {
            this.template = null;
            this.dataWatcherField = null;
            this.fieldNames = new String[0];
            return;
        }
        this.template = ClassTemplate.create(type);
        List<SafeField<?>> fields = this.template.getFields();
        this.fieldNames = new String[fields.size()];
        String dataWatcherField = null;
        int i = 0;
        while (i < fields.size()) {
            SafeField<?> field = fields.get(i);
            if (DataWatcherRef.TEMPLATE.isType(field.getType())) {
                dataWatcherField = field.getName();
            }
            this.fieldNames[i] = field.getName();
            ++i;
        }
        this.dataWatcherField = dataWatcherField;
    }

    public Object getPacket() {
        return this.template == null ? null : this.template.newInstance();
    }

    public int getId() {
        return this.id;
    }

    public String getMetaDataField() {
        if (this.dataWatcherField == null) {
            throw new IllegalArgumentException("MetaData field does not exist");
        }
        return this.dataWatcherField;
    }

    public String getField(int index) {
        return index >= 0 && index < this.fieldNames.length ? this.fieldNames[index] : null;
    }

    public static PacketType fromId(int id) {
        if (id >= 0 && id < 256) {
            return byId[id];
        }
        return UNKNOWN;
    }
}

