/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.permissions;

import com.bergerkiller.bukkit.common.permissions.IPermissionDefault;
import com.bergerkiller.bukkit.common.permissions.NoPermissionException;
import com.bergerkiller.bukkit.common.utils.CommonUtil;
import com.bergerkiller.bukkit.common.utils.StringUtil;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.PermissionDefault;

public abstract class PermissionEnum
implements IPermissionDefault {
    private final String node;
    private final String name;
    private final PermissionDefault def;
    private final String desc;

    protected PermissionEnum(String node, PermissionDefault def, String description) {
        this(node, def, description, 1);
    }

    protected PermissionEnum(String node, PermissionDefault def, String description, int argCount) {
        this.node = node.toLowerCase();
        this.def = def;
        this.desc = description;
        this.name = String.valueOf(this.node) + StringUtil.getFilledString(".*", argCount);
    }

    public String getRootName() {
        return this.node;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PermissionDefault getDefault() {
        return this.def;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    public boolean handleMsg(CommandSender sender, String message) {
        return this.handleMsg(sender, message, StringUtil.EMPTY_ARRAY);
    }

    public boolean handleMsg(CommandSender sender, String message, String ... args) {
        if (this.has(sender, args)) {
            return true;
        }
        sender.sendMessage(message);
        return false;
    }

    public void handle(CommandSender sender) {
        this.handle(sender, StringUtil.EMPTY_ARRAY);
    }

    public void handle(CommandSender sender, String ... args) {
        if (!this.has(sender, args)) {
            throw new NoPermissionException();
        }
    }

    public boolean has(CommandSender sender) {
        return this.has(sender, StringUtil.EMPTY_ARRAY);
    }

    public boolean has(CommandSender sender, String ... args) {
        if (args.length == 0) {
            return CommonUtil.hasPermission(sender, this.node);
        }
        return PermissionEnum.check(sender, this.getRootName(), args, 0);
    }

    private static boolean check(CommandSender sender, String root, String[] args, int argIndex) {
        if (argIndex >= args.length) {
            return CommonUtil.hasPermission(sender, root.toLowerCase());
        }
        return PermissionEnum.check(sender, String.valueOf(root) + "." + args[argIndex], args, argIndex + 1) || PermissionEnum.check(sender, String.valueOf(root) + ".*", args, argIndex + 1);
    }
}

