/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.natives;

import com.bergerkiller.bukkit.common.utils.LogicUtil;
import com.bergerkiller.bukkit.common.utils.NativeUtil;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.server.v1_4_R1.Entity;

public class NativeEntityWrapper<T extends org.bukkit.entity.Entity>
implements Collection<T> {
    private final Collection entities;
    private final Class<T> type;

    public NativeEntityWrapper(Collection entities, Class<T> type) {
        this.entities = entities;
        this.type = type;
    }

    @Override
    public boolean add(org.bukkit.entity.Entity value) {
        return this.entities.add(NativeUtil.getNative(value));
    }

    @Override
    public boolean addAll(Collection<? extends T> values) {
        for (org.bukkit.entity.Entity chunk : values) {
            this.add(chunk);
        }
        return true;
    }

    @Override
    public void clear() {
        this.entities.clear();
    }

    @Override
    public boolean contains(Object value) {
        if (!(value instanceof org.bukkit.entity.Entity)) {
            return false;
        }
        return this.entities.contains(NativeUtil.getNative((org.bukkit.entity.Entity)value));
    }

    @Override
    public boolean containsAll(Collection<?> values) {
        for (Object o : values) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.entities.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator iter = this.entities.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public T next() {
                return NativeUtil.getEntity((Entity)iter.next(), NativeEntityWrapper.this.type);
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    @Override
    public boolean remove(Object value) {
        if (!(value instanceof org.bukkit.entity.Entity)) {
            return false;
        }
        return this.entities.remove(NativeUtil.getNative((org.bukkit.entity.Entity)value));
    }

    @Override
    public boolean removeAll(Collection<?> values) {
        boolean succ = true;
        for (Object o : values) {
            if (this.remove(o)) continue;
            succ = false;
        }
        return succ;
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return false;
    }

    @Override
    public int size() {
        return this.entities.size();
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        Iterator<T> iter = this.iterator();
        int i = 0;
        while (i < array.length) {
            array[i] = iter.next();
            ++i;
        }
        return array;
    }

    @Override
    public <K> K[] toArray(K[] array) {
        if (this.size() > array.length) {
            array = LogicUtil.createArray(array.getClass().getComponentType(), this.size());
        }
        Iterator<T> iter = this.iterator();
        int i = 0;
        while (iter.hasNext()) {
            array[i] = iter.next();
            ++i;
        }
        return array;
    }
}

