/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.natives;

import com.bergerkiller.bukkit.common.utils.LogicUtil;
import com.bergerkiller.bukkit.common.utils.NativeUtil;
import java.util.Collection;
import java.util.Iterator;
import org.bukkit.Chunk;

public class NativeChunkWrapper
implements Collection<Chunk> {
    private final Collection<net.minecraft.server.v1_4_R1.Chunk> chunks;

    public NativeChunkWrapper(Collection<net.minecraft.server.v1_4_R1.Chunk> chunks) {
        this.chunks = chunks;
    }

    @Override
    public boolean add(Chunk value) {
        return this.chunks.add(NativeUtil.getNative(value));
    }

    @Override
    public boolean addAll(Collection<? extends Chunk> values) {
        for (Chunk chunk : values) {
            this.add(chunk);
        }
        return true;
    }

    @Override
    public void clear() {
        this.chunks.clear();
    }

    @Override
    public boolean contains(Object value) {
        if (!(value instanceof Chunk)) {
            return false;
        }
        return this.chunks.contains(NativeUtil.getNative((Chunk)value));
    }

    @Override
    public boolean containsAll(Collection<?> values) {
        for (Object o : values) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.chunks.isEmpty();
    }

    @Override
    public Iterator<Chunk> iterator() {
        final Iterator<net.minecraft.server.v1_4_R1.Chunk> iter = this.chunks.iterator();
        return new Iterator<Chunk>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Chunk next() {
                net.minecraft.server.v1_4_R1.Chunk c = (net.minecraft.server.v1_4_R1.Chunk)iter.next();
                return c == null ? null : c.bukkitChunk;
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    @Override
    public boolean remove(Object value) {
        if (!(value instanceof Chunk)) {
            return false;
        }
        return this.chunks.remove(NativeUtil.getNative((Chunk)value));
    }

    @Override
    public boolean removeAll(Collection<?> values) {
        boolean succ = true;
        for (Object o : values) {
            if (this.remove(o)) continue;
            succ = false;
        }
        return succ;
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return false;
    }

    @Override
    public int size() {
        return this.chunks.size();
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        Iterator<Chunk> iter = this.iterator();
        int i = 0;
        while (i < array.length) {
            array[i] = iter.next();
            ++i;
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Object[] rval = array.length >= this.size() ? array : LogicUtil.createArray(array.getClass().getComponentType(), this.size());
        Iterator<Chunk> iter = this.iterator();
        int i = 0;
        while (iter.hasNext()) {
            rval[i] = iter.next();
            ++i;
        }
        return rval;
    }
}

