/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.natives;

import com.bergerkiller.bukkit.common.utils.LogicUtil;
import com.bergerkiller.bukkit.common.utils.MathUtil;
import com.bergerkiller.bukkit.common.utils.NativeUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.server.v1_4_R1.Chunk;
import org.bukkit.entity.Entity;

public class NativeChunkEntitiesWrapper
implements Collection<Entity> {
    private final Chunk chunk;

    public NativeChunkEntitiesWrapper(org.bukkit.Chunk chunk) {
        this.chunk = NativeUtil.getNative(chunk);
    }

    @Override
    public int size() {
        int size = 0;
        List[] listArray = this.chunk.entitySlices;
        int n = this.chunk.entitySlices.length;
        int n2 = 0;
        while (n2 < n) {
            List list = listArray[n2];
            size = list.size();
            ++n2;
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        List[] listArray = this.chunk.entitySlices;
        int n = this.chunk.entitySlices.length;
        int n2 = 0;
        while (n2 < n) {
            List list = listArray[n2];
            if (!list.isEmpty()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean contains(Object o) {
        List[] listArray = this.chunk.entitySlices;
        int n = this.chunk.entitySlices.length;
        int n2 = 0;
        while (n2 < n) {
            List list = listArray[n2];
            if (list.contains(o)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Iterator<Entity> iterator() {
        return new NativeChunkEntitiesIterator(this.chunk.entitySlices);
    }

    @Override
    public Object[] toArray() {
        Object[] rval = new Object[this.size()];
        Iterator<Entity> iter = this.iterator();
        int i = 0;
        while (i < rval.length) {
            rval[i] = iter.next();
            ++i;
        }
        return rval;
    }

    @Override
    public <K> K[] toArray(K[] array) {
        int size = this.size();
        if (size > array.length) {
            array = LogicUtil.createArray(array.getClass().getComponentType(), size);
        }
        Iterator<Entity> iter = this.iterator();
        int i = 0;
        while (iter.hasNext()) {
            array[i] = iter.next();
            ++i;
        }
        return array;
    }

    private int getChunkY(net.minecraft.server.v1_4_R1.Entity entity) {
        return MathUtil.clamp(MathUtil.floor(entity.locY / 16.0), 0, this.chunk.entitySlices.length - 1);
    }

    @Override
    public boolean add(Entity entity) {
        net.minecraft.server.v1_4_R1.Entity e = NativeUtil.getNative(entity);
        if (e == null) {
            return false;
        }
        return this.chunk.entitySlices[this.getChunkY(e)].add(e);
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Entity)) {
            return false;
        }
        net.minecraft.server.v1_4_R1.Entity e = NativeUtil.getNative((Entity)o);
        if (this.chunk.entitySlices[this.getChunkY(e)].remove(e)) {
            return true;
        }
        List[] listArray = this.chunk.entitySlices;
        int n = this.chunk.entitySlices.length;
        int n2 = 0;
        while (n2 < n) {
            List list = listArray[n2];
            if (list.remove(e)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Entity> c) {
        boolean val = true;
        for (Entity entity : c) {
            if (this.add(entity)) continue;
            val = false;
        }
        return val;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean val = true;
        for (Object o : c) {
            if (this.remove(o)) continue;
            val = false;
        }
        return val;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public void clear() {
        List[] listArray = this.chunk.entitySlices;
        int n = this.chunk.entitySlices.length;
        int n2 = 0;
        while (n2 < n) {
            List list = listArray[n2];
            list.clear();
            ++n2;
        }
    }

    private static class NativeChunkEntitiesIterator
    implements Iterator<Entity> {
        private final Iterator<List> listIter;
        private Iterator<net.minecraft.server.v1_4_R1.Entity> entityIter;

        public NativeChunkEntitiesIterator(List[] lists) {
            this.listIter = Arrays.asList(lists).iterator();
            this.nextElem();
        }

        private void nextElem() {
            if (!this.hasNext()) {
                this.entityIter = this.listIter.hasNext() ? this.listIter.next().iterator() : null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.entityIter != null && this.entityIter.hasNext();
        }

        @Override
        public Entity next() {
            Entity next = NativeUtil.getEntity(this.entityIter.next());
            this.nextElem();
            return next;
        }

        @Override
        public void remove() {
            this.entityIter.remove();
            this.nextElem();
        }
    }
}

