/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.inventory;

import com.bergerkiller.bukkit.common.inventory.InventoryBase;
import com.bergerkiller.bukkit.common.utils.LogicUtil;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class MergedInventory
extends InventoryBase {
    private final Inventory[] inventories;
    private final int size;

    public MergedInventory(Inventory ... inventories) {
        this.inventories = inventories;
        int size = 0;
        Inventory[] inventoryArray = inventories;
        int n = inventories.length;
        int n2 = 0;
        while (n2 < n) {
            Inventory inventory = inventoryArray[n2];
            size += inventory.getSize();
            ++n2;
        }
        this.size = size;
    }

    @Override
    public ItemStack[] getContents() {
        if (LogicUtil.nullOrEmpty(this.inventories)) {
            return new ItemStack[0];
        }
        if (this.inventories.length == 1) {
            return this.inventories[0].getContents();
        }
        ItemStack[] rval = new ItemStack[this.getSize()];
        int i = 0;
        Inventory[] inventoryArray = this.inventories;
        int n = this.inventories.length;
        int n2 = 0;
        while (n2 < n) {
            Inventory inv = inventoryArray[n2];
            ItemStack[] itemStackArray = inv.getContents();
            int n3 = itemStackArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ItemStack stack;
                rval[i] = stack = itemStackArray[n4];
                ++i;
                ++n4;
            }
            ++n2;
        }
        return rval;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public ItemStack getItem(int index) {
        Inventory[] inventoryArray = this.inventories;
        int n = this.inventories.length;
        int n2 = 0;
        while (n2 < n) {
            Inventory inventory = inventoryArray[n2];
            int size = inventory.getSize();
            if (index < size) {
                return inventory.getItem(index);
            }
            index -= size;
            ++n2;
        }
        return null;
    }

    @Override
    public void setItem(int index, ItemStack arg1) {
        Inventory[] inventoryArray = this.inventories;
        int n = this.inventories.length;
        int n2 = 0;
        while (n2 < n) {
            Inventory inventory = inventoryArray[n2];
            int size = inventory.getSize();
            if (index < size) {
                inventory.setItem(index, arg1);
                return;
            }
            index -= size;
            ++n2;
        }
    }
}

