/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.inventory;

import com.bergerkiller.bukkit.common.utils.LogicUtil;
import com.bergerkiller.bukkit.common.utils.ParseUtil;
import com.bergerkiller.bukkit.common.utils.StringUtil;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemParser {
    private int data;
    private Material type;
    private int amount;

    public ItemParser(Material type) {
        this(type, -1);
    }

    public ItemParser(Material type, int amount) {
        this(type, amount, -1);
    }

    public ItemParser(Material type, int amount, int data) {
        this.amount = amount;
        this.data = data;
        this.type = type;
    }

    private ItemParser() {
        this.data = -1;
        this.type = null;
        this.amount = 1;
    }

    public static ItemParser parse(String fullname) {
        fullname = fullname.trim();
        int index = StringUtil.firstIndexOf(fullname, "x", "X", "*", " ", "@");
        if (index == -1) {
            return ItemParser.parse(fullname, null);
        }
        return ItemParser.parse(fullname.substring(index + 1), fullname.substring(0, index));
    }

    public static ItemParser parse(String name, String amount) {
        int index = name.indexOf(58);
        if (index == -1) {
            return ItemParser.parse(name, null, amount);
        }
        return ItemParser.parse(name.substring(0, index), name.substring(index + 1), amount);
    }

    public static ItemParser parse(String name, String dataname, String amount) {
        ItemParser parser = new ItemParser();
        parser.amount = ParseUtil.parseInt(amount, -1);
        parser.type = ParseUtil.parseMaterial(name, null);
        if (parser.hasType() && !LogicUtil.nullOrEmpty(dataname)) {
            Byte dat = ParseUtil.parseMaterialData(dataname, parser.type, null);
            parser.data = dat == null ? -1 : dat.intValue();
        }
        return parser;
    }

    public boolean match(ItemStack stack) {
        return this.match(stack.getTypeId(), (int)stack.getData().getData());
    }

    public boolean match(Material type, int data) {
        return this.match(type.getId(), data);
    }

    public boolean match(int typeid, int data) {
        if (this.hasType() && typeid != this.getTypeId()) {
            return false;
        }
        return !this.hasData() || data == this.getData();
    }

    public boolean hasAmount() {
        return this.amount >= 0;
    }

    public boolean hasData() {
        return this.data >= 0;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public int getData() {
        return this.data;
    }

    public int getAmount() {
        return this.amount;
    }

    public Material getType() {
        return this.type;
    }

    public int getTypeId() {
        return this.type == null ? -1 : this.type.getId();
    }

    public ItemStack getItemStack() {
        return this.getItemStack(this.amount);
    }

    public ItemStack getItemStack(int amount) {
        return new ItemStack(this.type, this.amount, (short)((byte)this.data));
    }

    public int getMaxStackSize() {
        if (this.hasData()) {
            return this.getItemStack(1).getMaxStackSize();
        }
        return this.getType().getMaxStackSize();
    }

    public ItemParser setData(Byte data) {
        return new ItemParser(this.type, this.amount, data.byteValue());
    }

    public ItemParser setAmount(int amount) {
        return new ItemParser(this.type, amount, this.data);
    }

    public ItemParser multiplyAmount(int amount) {
        if (this.hasAmount()) {
            amount *= this.getAmount();
        }
        return this.setAmount(amount);
    }

    public String toString() {
        StringBuilder rval = new StringBuilder();
        if (this.hasAmount()) {
            rval.append(this.amount).append(" of ");
        }
        if (this.hasType()) {
            rval.append(this.type.toString().toLowerCase());
            if (this.hasData()) {
                rval.append(':').append(this.data);
            }
        } else {
            rval.append("any type");
        }
        return rval.toString();
    }
}

