/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.inventory;

import com.bergerkiller.bukkit.common.inventory.InventoryBase;
import com.bergerkiller.bukkit.common.utils.ItemUtil;
import java.util.Collection;
import org.bukkit.inventory.ItemStack;

public class InventoryBaseImpl
extends InventoryBase {
    private final ItemStack[] items;

    public InventoryBaseImpl(int size) {
        this(new ItemStack[size], false);
    }

    public InventoryBaseImpl(Collection<ItemStack> contents) {
        this(contents, true);
    }

    public InventoryBaseImpl(Collection<ItemStack> contents, boolean clone) {
        this(contents.toArray(new ItemStack[0]), false);
        if (clone) {
            int i = 0;
            while (i < this.items.length) {
                this.items[i] = ItemUtil.cloneItem(this.items[i]);
                ++i;
            }
        }
    }

    public InventoryBaseImpl(ItemStack[] contents) {
        this(contents, true);
    }

    public InventoryBaseImpl(ItemStack[] contents, boolean clone) {
        this.items = clone ? ItemUtil.cloneItems(contents) : contents;
    }

    @Override
    public int getSize() {
        return this.items.length;
    }

    @Override
    public void setItem(int index, ItemStack item) {
        this.items[index] = ItemUtil.cloneItem(item);
    }

    @Override
    public ItemStack getItem(int index) {
        return ItemUtil.cloneItem(this.items[index]);
    }

    @Override
    public ItemStack[] getContents() {
        return ItemUtil.cloneItems(this.items);
    }
}

