/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.inventory;

import com.bergerkiller.bukkit.common.natives.IInventoryBase;
import com.bergerkiller.bukkit.common.utils.ItemUtil;
import java.util.Collections;
import java.util.List;
import net.minecraft.server.v1_4_R1.IInventory;
import org.bukkit.craftbukkit.v1_4_R1.inventory.CraftInventory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public abstract class InventoryBase
extends CraftInventory
implements Inventory {
    private int maxStackSize = 64;

    public InventoryBase() {
        this(new BaseInventoryNative());
    }

    private InventoryBase(BaseInventoryNative internal) {
        super((IInventory)internal);
        internal.owner = this;
    }

    @Deprecated
    public IInventory getInventory() {
        return null;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public String getTitle() {
        return this.getName();
    }

    public abstract int getSize();

    public abstract ItemStack getItem(int var1);

    public abstract void setItem(int var1, ItemStack var2);

    public List<HumanEntity> getViewers() {
        return Collections.emptyList();
    }

    public void clear() {
        int size = this.getSize();
        int i = 0;
        while (i < size) {
            this.setItem(i, null);
            ++i;
        }
    }

    public ItemStack[] getContents() {
        int size = this.getSize();
        ItemStack[] items = new ItemStack[size];
        int i = 0;
        while (i < size) {
            items[i] = ItemUtil.cloneItem(this.getItem(i));
            ++i;
        }
        return items;
    }

    public void setContents(ItemStack[] items) {
        int size = this.getSize();
        if (size < items.length) {
            throw new IllegalArgumentException("Invalid inventory size; expected " + size + " or less");
        }
        int i = 0;
        while (i < size) {
            this.setItem(i, i >= items.length ? null : items[i]);
            ++i;
        }
    }

    public InventoryType getType() {
        return null;
    }

    public InventoryHolder getHolder() {
        return null;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public void setMaxStackSize(int size) {
        this.maxStackSize = size;
    }

    private static class BaseInventoryNative
    extends IInventoryBase {
        private InventoryBase owner;

        private BaseInventoryNative() {
        }

        @Override
        public int getMaxStackSize() {
            return this.owner.getMaxStackSize();
        }
    }
}

