/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.inventory;

import com.bergerkiller.bukkit.common.reflection.SafeField;
import com.bergerkiller.bukkit.common.utils.BlockUtil;
import com.bergerkiller.bukkit.common.utils.ItemUtil;
import com.bergerkiller.bukkit.common.utils.NativeUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.v1_4_R1.IRecipe;
import net.minecraft.server.v1_4_R1.MathHelper;
import net.minecraft.server.v1_4_R1.ShapedRecipes;
import net.minecraft.server.v1_4_R1.ShapelessRecipes;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CraftRecipe {
    private static final SafeField<net.minecraft.server.v1_4_R1.ItemStack[]> srItems = new SafeField(ShapedRecipes.class, "items");
    private static final SafeField<List<net.minecraft.server.v1_4_R1.ItemStack>> slIngredients = new SafeField(ShapelessRecipes.class, "ingredients");
    private final ItemStack[] input;
    private final ItemStack[] output;

    private CraftRecipe(net.minecraft.server.v1_4_R1.ItemStack[] input, net.minecraft.server.v1_4_R1.ItemStack output) {
        ArrayList<net.minecraft.server.v1_4_R1.ItemStack> newinput = new ArrayList<net.minecraft.server.v1_4_R1.ItemStack>(input.length);
        net.minecraft.server.v1_4_R1.ItemStack[] itemStackArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            net.minecraft.server.v1_4_R1.ItemStack item = itemStackArray[n2];
            if (item != null) {
                boolean create = true;
                for (net.minecraft.server.v1_4_R1.ItemStack newitem : newinput) {
                    if (newitem.id != item.id || newitem.getData() != item.getData()) continue;
                    ++newitem.count;
                    create = false;
                    break;
                }
                if (create) {
                    item = item.cloneItemStack();
                    item.count = 1;
                    newinput.add(item);
                }
            }
            ++n2;
        }
        this.input = NativeUtil.getItemStacks(newinput.toArray(new net.minecraft.server.v1_4_R1.ItemStack[0]));
        ArrayList<net.minecraft.server.v1_4_R1.ItemStack> newoutput = new ArrayList<net.minecraft.server.v1_4_R1.ItemStack>(1);
        newoutput.add(output.cloneItemStack());
        for (net.minecraft.server.v1_4_R1.ItemStack stack : newinput) {
            if (!BlockUtil.isType(stack.id, Material.LAVA_BUCKET, Material.WATER_BUCKET, Material.MILK_BUCKET)) continue;
            net.minecraft.server.v1_4_R1.ItemStack s = stack.cloneItemStack();
            s.id = Material.BUCKET.getId();
            newoutput.add(s);
        }
        this.output = NativeUtil.getItemStacks(newoutput.toArray(new net.minecraft.server.v1_4_R1.ItemStack[0]));
    }

    public ItemStack getInput(int index) {
        return this.input[index];
    }

    public ItemStack[] getInput() {
        return this.input;
    }

    public ItemStack[] getOutput() {
        return this.output;
    }

    public int getInputSize() {
        int count = 0;
        ItemStack[] itemStackArray = this.input;
        int n = this.input.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack item = itemStackArray[n2];
            count += item.getAmount();
            ++n2;
        }
        return count;
    }

    public int getOutputSize() {
        int count = 0;
        ItemStack[] itemStackArray = this.output;
        int n = this.output.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack item = itemStackArray[n2];
            count += item.getAmount();
            ++n2;
        }
        return count;
    }

    public int craftItems(Inventory inventory, int itemlimit) {
        int lim = MathHelper.floor((double)((double)itemlimit / (double)this.output[0].getAmount()));
        return this.craft(inventory, lim) * this.output[0].getAmount();
    }

    public int craft(Inventory inventory, int limit) {
        int amount = 0;
        while (amount < limit && this.craft(inventory)) {
            ++amount;
        }
        return amount;
    }

    public boolean craft(Inventory inventory) {
        ItemStack item;
        ItemStack[] itemStackArray = this.input;
        int n = this.input.length;
        int n2 = 0;
        while (n2 < n) {
            item = itemStackArray[n2];
            if (ItemUtil.getItemCount(inventory, item.getTypeId(), item.getDurability()) < item.getAmount()) {
                return false;
            }
            ++n2;
        }
        if (!ItemUtil.canTransferAll(this.output, inventory)) {
            return false;
        }
        itemStackArray = this.input;
        n = this.input.length;
        n2 = 0;
        while (n2 < n) {
            item = itemStackArray[n2];
            ItemUtil.removeItems(inventory, item);
            ++n2;
        }
        itemStackArray = this.output;
        n = this.output.length;
        n2 = 0;
        while (n2 < n) {
            item = itemStackArray[n2];
            ItemUtil.transfer(ItemUtil.cloneItem(item), inventory, Integer.MAX_VALUE);
            ++n2;
        }
        return true;
    }

    public static CraftRecipe create(IRecipe recipe) {
        if (recipe instanceof ShapedRecipes) {
            return CraftRecipe.create(srItems.get(recipe), recipe.b());
        }
        if (recipe instanceof ShapelessRecipes) {
            return CraftRecipe.create(slIngredients.get(recipe), recipe.b());
        }
        return null;
    }

    public static CraftRecipe create(List<net.minecraft.server.v1_4_R1.ItemStack> input, net.minecraft.server.v1_4_R1.ItemStack output) {
        if (input == null) {
            return null;
        }
        return CraftRecipe.create(input.toArray(new net.minecraft.server.v1_4_R1.ItemStack[0]), output);
    }

    public static CraftRecipe create(net.minecraft.server.v1_4_R1.ItemStack[] input, net.minecraft.server.v1_4_R1.ItemStack output) {
        if (input == null || output == null || input.length == 0) {
            return null;
        }
        return new CraftRecipe(input, output);
    }
}

