/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.internal;

import com.bergerkiller.bukkit.common.events.EntityAddEvent;
import com.bergerkiller.bukkit.common.events.EntityRemoveEvent;
import com.bergerkiller.bukkit.common.internal.CommonPlugin;
import com.bergerkiller.bukkit.common.reflection.classes.WorldServerRef;
import com.bergerkiller.bukkit.common.utils.CommonUtil;
import com.bergerkiller.bukkit.common.utils.NativeUtil;
import java.util.HashSet;
import net.minecraft.server.v1_4_R1.Entity;
import net.minecraft.server.v1_4_R1.EntityHuman;
import net.minecraft.server.v1_4_R1.EntityPlayer;
import net.minecraft.server.v1_4_R1.IWorldAccess;
import net.minecraft.server.v1_4_R1.WorldManager;
import org.bukkit.World;

class CommonWorldListener
extends WorldManager {
    private boolean isEnabled = false;
    private HashSet<EntityPlayer> addedPlayers = new HashSet();

    public CommonWorldListener(World world) {
        super(CommonUtil.getMCServer(), NativeUtil.getNative(world));
    }

    public static boolean isValid() {
        return WorldServerRef.accessList.isValid();
    }

    public void enable() {
        if (CommonWorldListener.isValid()) {
            WorldServerRef.accessList.get(this.world).add((IWorldAccess)this);
            this.addedPlayers.addAll(this.world.players);
            this.isEnabled = true;
        } else {
            new RuntimeException("Failed to listen in World").printStackTrace();
        }
    }

    public void disable() {
        if (CommonWorldListener.isValid()) {
            WorldServerRef.accessList.get(this.world).remove((Object)this);
            this.addedPlayers.clear();
            this.isEnabled = false;
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public final void a(Entity added) {
        if (added != null) {
            if (added instanceof EntityPlayer && !this.addedPlayers.add((EntityPlayer)added)) {
                return;
            }
            CommonPlugin.getInstance().notifyAdded(NativeUtil.getEntity(added));
            CommonUtil.callEvent(new EntityAddEvent(NativeUtil.getEntity(added)));
        }
    }

    public final void b(Entity removed) {
        if (removed != null) {
            if (removed instanceof EntityPlayer && !this.addedPlayers.remove(removed)) {
                return;
            }
            CommonPlugin.getInstance().notifyRemoved(NativeUtil.getEntity(removed));
            CommonUtil.callEvent(new EntityRemoveEvent(NativeUtil.getEntity(removed)));
        }
    }

    public final void a(int arg0, int arg1, int arg2) {
    }

    public void a(int arg0, int arg1, int arg2, int arg3, int arg4) {
    }

    public void a(String name, double x, double y, double z, float yaw, float pitch) {
    }

    public void a(EntityHuman human, int code, int x, int y, int z, int dat) {
    }

    public void a(String name, double arg1, double arg2, double arg3, double arg4, double arg5, double arg6) {
    }

    public void b(int x, int y, int z) {
    }

    public void a(String name, int x, int y, int z) {
    }

    public void a(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
    }
}

