/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.internal;

import com.bergerkiller.bukkit.common.internal.CommonPlugin;
import com.bergerkiller.bukkit.common.protocol.PacketFields;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.ConnectionSide;
import com.comphenix.protocol.events.MonitorAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

class CommonProtocolLibHandler {
    CommonProtocolLibHandler() {
    }

    public static void register(CommonPlugin plugin) {
        ProtocolManager pm = ProtocolLibrary.getProtocolManager();
        pm.addPacketListener((PacketListener)new MonitorAdapter((Plugin)plugin, ConnectionSide.BOTH){

            public void onPacketReceiving(PacketEvent event) {
                PacketContainer packet = event.getPacket();
                Player player = event.getPlayer();
                if (!CommonPlugin.getInstance().onPacketReceive(player, packet.getHandle(), event.getPacketID())) {
                    event.setCancelled(true);
                }
            }

            public void onPacketSending(PacketEvent event) {
                PacketContainer packet = event.getPacket();
                Player player = event.getPlayer();
                if (!CommonPlugin.getInstance().onPacketSend(player, packet.getHandle(), event.getPacketID())) {
                    event.setCancelled(true);
                }
            }
        });
    }

    public static void sendSilentPacket(Player player, Object packet) {
        ProtocolManager pm = ProtocolLibrary.getProtocolManager();
        PacketContainer toSend = new PacketContainer(PacketFields.DEFAULT.packetID.get(packet).intValue(), packet);
        try {
            pm.sendServerPacket(player, toSend, false);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Invalid packet target");
        }
    }
}

