/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.internal;

import com.bergerkiller.bukkit.common.Common;
import com.bergerkiller.bukkit.common.EntityMap;
import com.bergerkiller.bukkit.common.PluginBase;
import com.bergerkiller.bukkit.common.Task;
import com.bergerkiller.bukkit.common.events.EntityMoveEvent;
import com.bergerkiller.bukkit.common.events.EntityRemoveFromServerEvent;
import com.bergerkiller.bukkit.common.events.PacketReceiveEvent;
import com.bergerkiller.bukkit.common.events.PacketSendEvent;
import com.bergerkiller.bukkit.common.internal.CommonClasses;
import com.bergerkiller.bukkit.common.internal.CommonListener;
import com.bergerkiller.bukkit.common.internal.CommonPacketListener;
import com.bergerkiller.bukkit.common.internal.CommonProtocolLibHandler;
import com.bergerkiller.bukkit.common.internal.CommonWorldListener;
import com.bergerkiller.bukkit.common.metrics.AddonHandler;
import com.bergerkiller.bukkit.common.natives.NativeSilentPacket;
import com.bergerkiller.bukkit.common.protocol.CommonPacket;
import com.bergerkiller.bukkit.common.protocol.PacketFields;
import com.bergerkiller.bukkit.common.protocol.PacketListener;
import com.bergerkiller.bukkit.common.reflection.classes.PlayerConnectionRef;
import com.bergerkiller.bukkit.common.utils.CommonUtil;
import com.bergerkiller.bukkit.common.utils.LogicUtil;
import com.bergerkiller.bukkit.common.utils.NativeUtil;
import com.bergerkiller.bukkit.common.utils.WorldUtil;
import com.kellerkindt.scs.ShowCaseStandalone;
import com.narrowtux.showcase.Showcase;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import me.snowleo.bleedingmobs.BleedingMobs;
import net.milkbowl.vault.permission.Permission;
import net.minecraft.server.v1_4_R1.Entity;
import net.minecraft.server.v1_4_R1.EntityPlayer;
import net.minecraft.server.v1_4_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_4_R1.entity.CraftItem;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class CommonPlugin
extends PluginBase {
    public static final String DEPENDENT_MC_VERSION = "v1_4_R1";
    public static final boolean IS_COMPATIBLE = Common.isMCVersionCompatible("v1_4_R1");
    private static CommonPlugin instance;
    public final List<PluginBase> plugins = new ArrayList<PluginBase>();
    protected final Map<World, CommonWorldListener> worldListeners = new HashMap<World, CommonWorldListener>();
    protected final ArrayList<SoftReference<EntityMap>> maps = new ArrayList();
    protected final List<PacketListener>[] listeners = new ArrayList[256];
    private final List<Runnable> nextTickTasks = new ArrayList<Runnable>();
    private final List<Runnable> nextTickSync = new ArrayList<Runnable>();
    private final List<Task> startedTasks = new ArrayList<Task>();
    private final HashSet<org.bukkit.entity.Entity> entitiesToRemove = new HashSet();
    private boolean vaultEnabled = false;
    private Permission vaultPermission = null;
    private boolean isShowcaseEnabled = false;
    private boolean isSCSEnabled = false;
    public boolean isProtocolLibEnabled = false;
    private Plugin bleedingMobsInstance = null;
    public List<Entity> entities = new ArrayList<Entity>();

    public static CommonPlugin getInstance() {
        return instance;
    }

    public void handleReflectionMissing(String type, String name, Class<?> source) {
        String msg = String.valueOf(type) + " '" + name + "' does not exist in class file " + source.getSimpleName();
        Exception ex = new Exception(msg);
        StackTraceElement[] stackTraceElementArray = ex.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement elem = stackTraceElementArray[n2];
            if (elem.getClassName().startsWith("com.bergerkiller.bukkit.common.reflection.classes")) {
                this.log(Level.SEVERE, String.valueOf(msg) + " (Update BKCommonLib?)");
                return;
            }
            ++n2;
        }
        ex.printStackTrace();
    }

    public void registerMap(EntityMap map) {
        this.maps.add(new SoftReference<EntityMap>(map));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextTick(Runnable runnable) {
        if (runnable != null) {
            List<Runnable> list = this.nextTickTasks;
            synchronized (list) {
                this.nextTickTasks.add(runnable);
            }
        }
    }

    public void notifyAdded(org.bukkit.entity.Entity e) {
        this.entitiesToRemove.remove(e);
    }

    public void notifyRemoved(org.bukkit.entity.Entity e) {
        this.entitiesToRemove.add(e);
    }

    public void notifyWorldAdded(World world) {
        if (this.worldListeners.containsKey(world)) {
            return;
        }
        CommonWorldListener listener = new CommonWorldListener(world);
        listener.enable();
        this.worldListeners.put(world, listener);
    }

    public boolean isEntityIgnored(org.bukkit.entity.Entity entity) {
        if (entity instanceof Item) {
            Item item = (Item)entity;
            if (this.isShowcaseEnabled) {
                try {
                    if (Showcase.instance.getItemByDrop(item) != null) {
                        return true;
                    }
                }
                catch (Throwable t) {
                    Bukkit.getLogger().log(Level.SEVERE, "Showcase item verification failed (update needed?), contact the authors!");
                    t.printStackTrace();
                    this.isShowcaseEnabled = false;
                }
            }
            if (this.isSCSEnabled) {
                try {
                    if (ShowCaseStandalone.get().isShowCaseItem(item)) {
                        return true;
                    }
                }
                catch (Throwable t) {
                    Bukkit.getLogger().log(Level.SEVERE, "ShowcaseStandalone item verification failed (update needed?), contact the authors!");
                    t.printStackTrace();
                    this.isSCSEnabled = false;
                }
            }
            if (this.bleedingMobsInstance != null) {
                try {
                    BleedingMobs bm = (BleedingMobs)this.bleedingMobsInstance;
                    if (bm.isSpawning() || bm.isWorldEnabled(item.getWorld()) && bm.isParticleItem(((CraftItem)item).getUniqueId())) {
                        return true;
                    }
                }
                catch (Throwable t) {
                    Bukkit.getLogger().log(Level.SEVERE, "Bleeding Mobs item verification failed (update needed?), contact the authors!");
                    t.printStackTrace();
                    this.bleedingMobsInstance = null;
                }
            }
        }
        return false;
    }

    public boolean hasPermission(CommandSender sender, String permissionNode) {
        if (this.vaultEnabled) {
            return this.vaultPermission.has(sender, permissionNode);
        }
        return sender.hasPermission(permissionNode);
    }

    public boolean onPacketSend(Player player, Object packet) {
        if (player == null || packet == null) {
            return true;
        }
        return this.onPacketSend(player, packet, PacketFields.DEFAULT.packetID.get(packet));
    }

    public void addPacketListener(PacketListener listener, int id) {
        if (listener == null || id < 0 || id >= this.listeners.length) {
            return;
        }
        if (this.listeners[id] == null) {
            this.listeners[id] = new ArrayList<PacketListener>();
        }
        this.listeners[id].add(listener);
    }

    public void removePacketListener(PacketListener listener) {
        if (listener == null) {
            return;
        }
        int i = 0;
        while (i < this.listeners.length) {
            if (!LogicUtil.nullOrEmpty(this.listeners[i])) {
                this.listeners[i].remove(listener);
            }
            ++i;
        }
    }

    public boolean onPacketSend(Player player, Object packet, int id) {
        if (player == null || packet == null) {
            return true;
        }
        if (!LogicUtil.nullOrEmpty(this.listeners[id])) {
            CommonPacket cp = new CommonPacket(packet, id);
            PacketSendEvent ev = new PacketSendEvent(player, cp);
            for (PacketListener listener : this.listeners[id]) {
                listener.onPacketSend(ev);
            }
            return !ev.isCancelled();
        }
        return true;
    }

    public boolean onPacketReceive(Player player, Object packet) {
        if (player == null || packet == null) {
            return true;
        }
        return this.onPacketReceive(player, packet, PacketFields.DEFAULT.packetID.get(packet));
    }

    public boolean onPacketReceive(Player player, Object packet, int id) {
        if (player == null || packet == null) {
            return true;
        }
        if (!LogicUtil.nullOrEmpty(this.listeners[id])) {
            CommonPacket cp = new CommonPacket(packet, id);
            PacketReceiveEvent ev = new PacketReceiveEvent(player, cp);
            for (PacketListener listener : this.listeners[id]) {
                listener.onPacketReceive(ev);
            }
            return !ev.isCancelled();
        }
        return true;
    }

    public void sendPacket(Player player, Object packet, boolean throughListeners) {
        if (packet == null || player == null) {
            return;
        }
        EntityPlayer ep = NativeUtil.getNative(player);
        if (ep.playerConnection == null || ep.playerConnection.disconnected) {
            return;
        }
        if (throughListeners) {
            PlayerConnectionRef.sendPacket(ep.playerConnection, packet);
        } else if (this.isProtocolLibEnabled) {
            CommonProtocolLibHandler.sendSilentPacket(player, packet);
        } else {
            PlayerConnectionRef.sendPacket(ep.playerConnection, (Object)new NativeSilentPacket(packet));
        }
    }

    @Override
    public void permissions() {
    }

    @Override
    public void updateDependency(Plugin plugin, String pluginName, boolean enabled) {
        if (pluginName.equals("Showcase")) {
            this.isShowcaseEnabled = enabled;
            if (enabled) {
                this.log(Level.INFO, "Showcase detected: Showcased items will be ignored");
            }
        } else if (pluginName.equals("ShowCaseStandalone")) {
            this.isSCSEnabled = enabled;
            if (enabled) {
                this.log(Level.INFO, "Showcase Standalone detected: Showcased items will be ignored");
            }
        } else if (pluginName.equals("BleedingMobs")) {
            Object object = this.bleedingMobsInstance = enabled ? plugin : null;
            if (enabled) {
                this.log(Level.INFO, "Bleeding Mobs detected: Particle items will be ignored");
            }
        } else if (pluginName.equals("Vault")) {
            if (enabled) {
                RegisteredServiceProvider permissionProvider = this.getServer().getServicesManager().getRegistration(Permission.class);
                if (permissionProvider != null) {
                    this.vaultPermission = (Permission)permissionProvider.getProvider();
                    this.vaultEnabled = this.vaultPermission != null;
                }
            } else {
                this.vaultPermission = null;
                this.vaultEnabled = false;
            }
        }
    }

    @Override
    public int getMinimumLibVersion() {
        return 0;
    }

    @Override
    public void setDisableMessage(String message) {
    }

    public void onLoad() {
        instance = this;
        CommonClasses.init();
    }

    @Override
    public void disable() {
        instance = null;
        for (CommonWorldListener listener : this.worldListeners.values()) {
            listener.disable();
        }
        this.worldListeners.clear();
        for (Task task : this.startedTasks) {
            task.stop();
        }
        this.startedTasks.clear();
        Player[] playerArray = Bukkit.getServer().getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            CommonPacketListener.unbind(player);
            ++n2;
        }
    }

    @Override
    public void enable() {
        int version;
        int dot2;
        if (!IS_COMPATIBLE) {
            this.log(Level.SEVERE, "BKCommonLib can only run on a CraftBukkit build compatible with Minecraft v1_4_R1");
            this.log(Level.SEVERE, "Please look for an available BKCommonLib update:");
            this.log(Level.SEVERE, "http://dev.bukkit.org/server-mods/bkcommonlib/");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.log(Level.INFO, "BKCommonLib is running on Minecraft v1_4_R1");
        this.log(Level.INFO, "MC version: " + Bukkit.getVersion());
        this.log(Level.INFO, "Bukkit version: " + Bukkit.getBukkitVersion());
        AddonHandler ah = new AddonHandler((Plugin)this);
        ah.startMetrics();
        this.register(new CommonListener());
        this.startedTasks.add(new NextTickHandler(this).start(1L, 1L));
        this.startedTasks.add(new MoveEventHandler(this).start(1L, 1L));
        this.startedTasks.add(new EntityRemovalHandler(this).start(1L, 1L));
        this.isProtocolLibEnabled = CommonUtil.getPlugin("ProtocolLib") != null;
        if (this.isProtocolLibEnabled) {
            CommonProtocolLibHandler.register(this);
        } else {
            Player[] playerArray = Bukkit.getServer().getOnlinePlayers();
            int n = playerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Player player = playerArray[n2];
                CommonPacketListener.bind(player);
                ++n2;
            }
        }
        for (World world : WorldUtil.getWorlds()) {
            this.notifyWorldAdded(world);
        }
        String ver = this.getVersion();
        int dot1 = ver.indexOf(46);
        if (dot1 != -1 && (dot2 = ver.indexOf(46, dot1 + 1)) != -1) {
            ver = ver.substring(0, dot2);
        }
        if ((version = this.getVersionNumber()) != 148) {
            this.log(Level.SEVERE, "Common.VERSION needs to be updated to contain '" + version + "'!");
        }
    }

    @Override
    public boolean command(CommandSender sender, String command, String[] args) {
        return false;
    }

    private static class EntityRemovalHandler
    extends Task {
        public EntityRemovalHandler(JavaPlugin plugin) {
            super(plugin);
        }

        @Override
        public void run() {
            HashSet entities = CommonPlugin.getInstance().entitiesToRemove;
            if (!entities.isEmpty()) {
                Iterator<SoftReference<EntityMap>> iter = CommonPlugin.getInstance().maps.iterator();
                while (iter.hasNext()) {
                    EntityMap map = iter.next().get();
                    if (map == null) {
                        iter.remove();
                        continue;
                    }
                    if (map.isEmpty()) continue;
                    map.keySet().removeAll(entities);
                }
                if (CommonUtil.hasHandlers(EntityRemoveFromServerEvent.getHandlerList())) {
                    for (org.bukkit.entity.Entity e : entities) {
                        CommonUtil.callEvent(new EntityRemoveFromServerEvent(e));
                    }
                }
                entities.clear();
            }
        }
    }

    private static class MoveEventHandler
    extends Task {
        public MoveEventHandler(JavaPlugin plugin) {
            super(plugin);
        }

        @Override
        public void run() {
            CommonPlugin cp = CommonPlugin.getInstance();
            if (CommonUtil.hasHandlers(EntityMoveEvent.getHandlerList())) {
                EntityMoveEvent event = new EntityMoveEvent();
                for (WorldServer world : NativeUtil.getWorlds()) {
                    cp.entities.addAll(world.entityList);
                    for (Entity entity : cp.entities) {
                        if (entity.locX == entity.lastX && entity.locY == entity.lastY && entity.locZ == entity.lastZ && entity.yaw == entity.lastYaw && entity.pitch == entity.lastPitch) continue;
                        event.setEntity(entity);
                        CommonUtil.callEvent(event);
                    }
                    cp.entities.clear();
                }
            }
        }
    }

    private static class NextTickHandler
    extends Task {
        public NextTickHandler(JavaPlugin plugin) {
            super(plugin);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List nextTick = CommonPlugin.getInstance().nextTickTasks;
            List nextSync = CommonPlugin.getInstance().nextTickSync;
            List list = nextTick;
            synchronized (list) {
                if (nextTick.isEmpty()) {
                    return;
                }
                nextSync.addAll(nextTick);
                nextTick.clear();
            }
            for (Runnable task : nextSync) {
                try {
                    task.run();
                }
                catch (Throwable t) {
                    instance.log(Level.SEVERE, "An error occurred in next-tick task '" + task.getClass().getName() + "':");
                    CommonUtil.filterStackTrace(t).printStackTrace();
                }
            }
            nextSync.clear();
        }
    }
}

