/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.internal;

import com.bergerkiller.bukkit.common.PluginBase;
import com.bergerkiller.bukkit.common.internal.CommonPacketListener;
import com.bergerkiller.bukkit.common.internal.CommonPlugin;
import com.bergerkiller.bukkit.common.internal.CommonWorldListener;
import com.bergerkiller.bukkit.common.utils.LogicUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldUnloadEvent;

class CommonListener
implements Listener {
    CommonListener() {
    }

    @EventHandler(priority=EventPriority.MONITOR)
    private void onPluginEnable(PluginEnableEvent event) {
        String name = LogicUtil.fixNull(event.getPlugin().getName(), "");
        for (PluginBase pb : CommonPlugin.getInstance().plugins) {
            pb.updateDependency(event.getPlugin(), name, true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    private void onPluginDisable(PluginDisableEvent event) {
        String name = LogicUtil.fixNull(event.getPlugin().getName(), "");
        for (PluginBase pb : CommonPlugin.getInstance().plugins) {
            pb.updateDependency(event.getPlugin(), name, false);
        }
        if (name.equalsIgnoreCase("ProtocolLib")) {
            Player[] playerArray = Bukkit.getServer().getOnlinePlayers();
            int n = playerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Player player = playerArray[n2];
                CommonPacketListener.bind(player);
                ++n2;
            }
            CommonPlugin.getInstance().isProtocolLibEnabled = false;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    private void onWorldInit(WorldInitEvent event) {
        CommonPlugin.getInstance().notifyWorldAdded(event.getWorld());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    private void onWorldUnload(WorldUnloadEvent event) {
        if (event.isCancelled()) {
            return;
        }
        CommonWorldListener listener = CommonPlugin.getInstance().worldListeners.remove(event.getWorld());
        if (listener != null) {
            listener.disable();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!CommonPlugin.getInstance().isProtocolLibEnabled) {
            CommonPacketListener.bind(event.getPlayer());
        }
    }
}

