/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.config;

import com.bergerkiller.bukkit.common.utils.StringUtil;
import java.util.LinkedList;

public class NodeBuilder {
    private LinkedList<String> nodes = new LinkedList();
    private final int indent;

    public NodeBuilder(int indent) {
        this.indent = indent;
    }

    public boolean handle(String line, int preceedingSpaces) {
        if (line.startsWith("#")) {
            return false;
        }
        int nodeIndex = preceedingSpaces / this.indent;
        String nodeName = StringUtil.getBefore(line, ":");
        if (!nodeName.isEmpty()) {
            while (this.nodes.size() >= nodeIndex + 1) {
                this.nodes.pollLast();
            }
            this.nodes.offerLast(nodeName);
            return true;
        }
        return false;
    }

    public String getPath() {
        return StringUtil.combine(".", this.nodes);
    }
}

