/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.config;

import com.bergerkiller.bukkit.common.config.ConfigurationNode;
import com.bergerkiller.bukkit.common.config.HeaderBuilder;
import com.bergerkiller.bukkit.common.config.NodeBuilder;
import com.bergerkiller.bukkit.common.utils.LogicUtil;
import com.bergerkiller.bukkit.common.utils.StreamUtil;
import com.bergerkiller.bukkit.common.utils.StringUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;

public class FileConfiguration
extends ConfigurationNode {
    private final File file;
    public static final String MAIN_HEADER_PREFIX = "#> ";

    public FileConfiguration(JavaPlugin plugin) {
        this(plugin, "config.yml");
    }

    public FileConfiguration(JavaPlugin plugin, String filepath) {
        this(plugin.getDataFolder() + File.separator + filepath);
    }

    public FileConfiguration(String filepath) {
        this(new File(filepath));
    }

    public FileConfiguration(File file) {
        this.file = file;
    }

    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public String getPath() {
        return "";
    }

    @Override
    public String getPath(String append) {
        return LogicUtil.nullOrEmpty(append) ? "" : append;
    }

    public void setIndent(int indent) {
        this.getSource().options().indent(indent);
    }

    public int getIndent() {
        return this.getSource().options().indent();
    }

    public void load() {
        try {
            FileInputStream stream = new FileInputStream(this.file);
            InputStreamReader reader = new InputStreamReader(stream);
            StringBuilder builder = new StringBuilder();
            BufferedReader input = new BufferedReader(reader);
            try {
                String line;
                HeaderBuilder header = new HeaderBuilder();
                NodeBuilder node = new NodeBuilder(this.getIndent());
                StringBuilder mainHeader = new StringBuilder();
                while ((line = input.readLine()) != null) {
                    int indent;
                    String trimmedLine = (line = StringUtil.ampToColor(line)).substring(indent = StringUtil.getSuccessiveCharCount(line, ' '));
                    if (trimmedLine.equals("*:")) {
                        trimmedLine = "'*':";
                        line = String.valueOf(StringUtil.getFilledString(" ", indent)) + trimmedLine;
                    }
                    if (trimmedLine.startsWith(MAIN_HEADER_PREFIX)) {
                        mainHeader.append('\n').append(trimmedLine.substring(MAIN_HEADER_PREFIX.length()));
                        continue;
                    }
                    if (header.handle(trimmedLine)) continue;
                    node.handle(trimmedLine, indent);
                    if (header.hasHeader()) {
                        this.setHeader(node.getPath(), header.getHeader());
                        header.clear();
                    }
                    builder.append(line).append('\n');
                }
                if (mainHeader.length() > 0) {
                    this.setHeader(mainHeader.toString());
                }
            }
            finally {
                input.close();
            }
            this.getSource().loadFromString(builder.toString());
        }
        catch (FileNotFoundException stream) {
        }
        catch (Exception ex) {
            Bukkit.getLogger().log(Level.SEVERE, "[Configuration] An error occured while loading file '" + this.file + "':");
            ex.printStackTrace();
        }
    }

    private void writeHeader(boolean main, BufferedWriter writer, String header, int indent) throws IOException {
        if (header != null) {
            String[] stringArray = header.split("\n", -1);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String headerLine = stringArray[n2];
                StreamUtil.writeIndent(writer, indent);
                if (main) {
                    writer.write(MAIN_HEADER_PREFIX);
                    writer.write(headerLine);
                } else if (headerLine.trim().length() > 0) {
                    writer.write("# ");
                    writer.write(headerLine);
                }
                writer.newLine();
                ++n2;
            }
        }
    }

    public void save() {
        try {
            boolean regen = !this.exists();
            for (String key : this.getSource().getKeys(true)) {
                String text;
                Object value = this.getSource().get(key);
                if (!(value instanceof String) || !(text = (String)value).contains("\n")) continue;
                this.getSource().set(key, Arrays.asList(text.split("\n", -1)));
            }
            this.file.getAbsoluteFile().getParentFile().mkdirs();
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.file));
            try {
                this.writeHeader(true, writer, this.getHeader(), 0);
                NodeBuilder node = new NodeBuilder(this.getIndent());
                String[] stringArray = this.getSource().saveToString().split("\n", -1);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int indent;
                    String line = stringArray[n2];
                    String trimmedLine = (line = StringUtil.colorToAmp(line)).substring(indent = StringUtil.getSuccessiveCharCount(line, ' '));
                    if (trimmedLine.equals("'*':")) {
                        trimmedLine = "*:";
                        line = String.valueOf(StringUtil.getFilledString(" ", indent)) + trimmedLine;
                    }
                    if (node.handle(trimmedLine, indent)) {
                        this.writeHeader(false, writer, this.getHeader(node.getPath()), indent);
                    }
                    writer.write(line);
                    writer.newLine();
                    ++n2;
                }
            }
            finally {
                writer.close();
            }
            if (regen) {
                Bukkit.getLogger().log(Level.INFO, "[Configuration] File '" + this.file + "' has been generated");
            }
        }
        catch (Exception ex) {
            Bukkit.getLogger().log(Level.SEVERE, "[Configuration] An error occured while saving to file '" + this.file + "':");
            ex.printStackTrace();
        }
    }
}

