/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.config;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public abstract class DataReader {
    private final File file;

    public DataReader(Plugin plugin, String filename) {
        this(plugin.getDataFolder(), filename);
    }

    public DataReader(File folder, String filename) {
        this(new File(folder, filename));
    }

    public DataReader(String filepath) {
        this(new File(filepath));
    }

    public DataReader(File file) {
        this.file = file;
    }

    public abstract void read(DataInputStream var1) throws IOException;

    public DataInputStream getStream(InputStream stream) {
        return new DataInputStream(stream);
    }

    public File getFile() {
        return this.file;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public final void read() {
        try {
            DataInputStream stream = this.getStream(new FileInputStream(this.file));
            try {
                try {
                    this.read(stream);
                }
                catch (IOException ex) {
                    Bukkit.getLogger().log(Level.SEVERE, "[Configuration] An IO Exception occured while loading file '" + this.file + "':");
                    ex.printStackTrace();
                    stream.close();
                }
                catch (Throwable t) {
                    Bukkit.getLogger().log(Level.SEVERE, "[Configuration] An error occured while loading file '" + this.file + "':");
                    t.printStackTrace();
                    stream.close();
                }
            }
            finally {
                stream.close();
            }
        }
        catch (FileNotFoundException stream) {
        }
        catch (Throwable t) {
            Bukkit.getLogger().log(Level.SEVERE, "[Configuration] An error occured while loading file '" + this.file + "':");
            t.printStackTrace();
        }
    }
}

