/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.config;

import com.bergerkiller.bukkit.common.utils.LogicUtil;
import com.bergerkiller.bukkit.common.utils.ParseUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigurationNode
implements Cloneable {
    private final MemorySection source;
    private final Map<String, String> headers;
    private final Set<String> readkeys;

    public ConfigurationNode() {
        this(new HashSet<String>(), new HashMap<String, String>(), (MemorySection)new YamlConfiguration());
    }

    private ConfigurationNode(ConfigurationNode source, String root) {
        this.readkeys = source.readkeys;
        this.headers = source.headers;
        MemorySection sect = (MemorySection)source.source.getConfigurationSection(root);
        this.source = sect == null ? (MemorySection)source.source.createSection(root) : sect;
        this.setRead();
    }

    private ConfigurationNode(Set<String> readkeys, Map<String, String> headers, MemorySection source) {
        this.readkeys = readkeys;
        this.source = source;
        this.headers = headers;
    }

    public boolean hasParent() {
        return this.source.getParent() != null;
    }

    public boolean isEmpty() {
        return this.getKeys().isEmpty();
    }

    public ConfigurationNode getParent() {
        MemorySection sec = (MemorySection)this.source.getParent();
        if (sec == null) {
            return null;
        }
        return new ConfigurationNode(this.readkeys, this.headers, sec);
    }

    public String getPath(String append) {
        String p = this.getPath();
        if (LogicUtil.nullOrEmpty(append)) {
            return p;
        }
        if (LogicUtil.nullOrEmpty(p)) {
            return append;
        }
        return String.valueOf(p) + "." + append;
    }

    public String getPath() {
        return this.source.getCurrentPath();
    }

    public String getName() {
        return this.source.getName();
    }

    public String getHeader() {
        return this.headers.get(this.getPath());
    }

    public String getHeader(String path) {
        return this.headers.get(this.getPath(path));
    }

    public void removeHeader() {
        this.setHeader(null);
    }

    public void removeHeader(String path) {
        this.setHeader(path, null);
    }

    public void setHeader(String header) {
        this.setHeader("", header);
    }

    public void setHeader(String path, String header) {
        if (header == null) {
            this.headers.remove(this.getPath(path));
        } else {
            this.headers.put(this.getPath(path), header);
        }
    }

    public void addHeader(String header) {
        this.addHeader("", header);
    }

    public void addHeader(String path, String header) {
        String oldheader = this.getHeader(path);
        if (oldheader == null) {
            this.setHeader(path, header);
        } else {
            this.setHeader(path, String.valueOf(oldheader) + "\n" + header);
        }
    }

    public Map<String, String> getHeaders() {
        String root = this.getPath();
        HashMap<String, String> rval = new HashMap<String, String>(this.headers.size());
        if (LogicUtil.nullOrEmpty(root)) {
            rval.putAll(this.headers);
        } else {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                if (!entry.getKey().startsWith(root)) continue;
                rval.put(entry.getKey(), entry.getValue());
            }
        }
        return rval;
    }

    public void clearHeaders() {
        String root = this.getPath();
        if (root == null || root.length() == 0) {
            this.headers.clear();
        } else {
            Iterator<Map.Entry<String, String>> iter = this.headers.entrySet().iterator();
            while (iter.hasNext()) {
                if (!iter.next().getKey().startsWith(root)) continue;
                iter.remove();
            }
        }
    }

    public MemorySection getSection() {
        return this.source;
    }

    public YamlConfiguration getSource() {
        return (YamlConfiguration)this.source.getRoot();
    }

    public boolean isNode(String path) {
        return this.source.isConfigurationSection(path);
    }

    public ConfigurationNode getNode(String path) {
        return new ConfigurationNode(this, path);
    }

    public Set<ConfigurationNode> getNodes() {
        HashSet<ConfigurationNode> rval = new HashSet<ConfigurationNode>();
        for (String path : this.getKeys()) {
            if (!this.isNode(path)) continue;
            rval.add(this.getNode(path));
        }
        return rval;
    }

    public Map<String, Object> getValues() {
        return this.source.getValues(false);
    }

    public <T> Map<String, T> getValues(Class<T> type) {
        Map<String, Object> values = this.getValues();
        Iterator<Map.Entry<String, Object>> iter = values.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Object> entry = iter.next();
            Class<T> newvalue = ParseUtil.convert(entry.getValue(), type);
            if (newvalue == null) {
                iter.remove();
                continue;
            }
            entry.setValue(newvalue);
        }
        return values;
    }

    public Set<String> getKeys() {
        return this.source.getKeys(false);
    }

    public ConfigurationNode clone() {
        ConfigurationNode cloned = new ConfigurationNode();
        cloned.setHeader(this.getHeader());
        for (String key : this.getKeys()) {
            if (this.isNode(key)) {
                cloned.set(key, this.getNode(key).clone());
                continue;
            }
            cloned.set(key, this.get(key));
        }
        return cloned;
    }

    public boolean isRead() {
        return this.isRead(null);
    }

    public boolean isRead(String path) {
        return this.readkeys.contains(this.getPath(path));
    }

    public void setRead() {
        this.setRead(null);
    }

    public void setRead(String path) {
        this.setReadFullPath(this.getPath(path));
    }

    private void setReadFullPath(String path) {
        int dotindex;
        if (this.readkeys.add(path) && (dotindex = path.lastIndexOf(46)) > 0) {
            this.setReadFullPath(path.substring(0, dotindex));
        }
    }

    public void trim() {
        for (String key : this.getKeys()) {
            if (this.isRead(key)) {
                if (!this.isNode(key)) continue;
                this.getNode(key).trim();
                continue;
            }
            this.remove(key);
        }
    }

    public boolean contains(String path) {
        return this.source.contains(path);
    }

    public void clear() {
        for (String key : this.getKeys()) {
            this.remove(key);
        }
    }

    public void remove(String path) {
        this.set(path, null);
    }

    public void set(String path, Object value) {
        if (value != null) {
            this.setRead(path);
            if (value.getClass().isEnum()) {
                String text = value.toString();
                value = text.equals("true") ? Boolean.valueOf(true) : (text.equals("false") ? Boolean.valueOf(false) : text);
            }
        }
        this.source.set(path, value);
    }

    public List getList(String path) {
        this.setRead(path);
        return this.source.getList(path);
    }

    public <T> List<T> getList(String path, Class<T> type) {
        return this.getList(path, type, new ArrayList());
    }

    public <T> List<T> getList(String path, Class<T> type, List<T> def) {
        List list = this.getList(path);
        if (list != null) {
            def = new ArrayList<T>();
            for (Object o : list) {
                Class<T> val = ParseUtil.convert(o, type);
                if (val == null) continue;
                def.add(val);
            }
        }
        this.set(path, def);
        return def;
    }

    public Object get(String path) {
        this.setRead(path);
        return this.source.get(path);
    }

    public <T> T get(String path, Class<T> type) {
        return this.get(path, type, null);
    }

    public <T> T get(String path, T def) {
        return (T)this.get(path, def.getClass(), def);
    }

    public <T> T get(String path, Class<T> type, T def) {
        T rval = ParseUtil.convert(this.get(path), type, def);
        this.set(path, rval);
        return rval;
    }

    public void shareWith(Map<String, Object> target, String path, Object def) {
        Object value = this.get(path);
        if (value != null) {
            target.put(path, value);
        } else {
            value = target.get(path);
            if (value == null) {
                value = def;
                target.put(path, value);
            }
            this.set(path, value);
        }
    }
}

