/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.bases;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.server.v1_4_R1.ChunkPosition;
import org.bukkit.World;
import org.bukkit.block.Block;

public class IntVector3 {
    public final int x;
    public final int y;
    public final int z;

    public IntVector3(Block block) {
        this(block.getX(), block.getY(), block.getZ());
    }

    public IntVector3(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int hashCode() {
        return this.x + this.z << 8 + this.y << 16;
    }

    public ChunkPosition toPosition() {
        return new ChunkPosition(this.x, this.y, this.z);
    }

    public Block toBlock(World world) {
        return world.getBlockAt(this.x, this.y, this.z);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof IntVector3) {
            IntVector3 vec = (IntVector3)object;
            return vec.x == this.x && vec.y == this.y && vec.z == this.z;
        }
        return false;
    }

    public static IntVector3 read(DataInputStream stream) throws IOException {
        return new IntVector3(stream.readInt(), stream.readInt(), stream.readInt());
    }

    public void write(DataOutputStream stream) throws IOException {
        stream.writeInt(this.x);
        stream.writeInt(this.y);
        stream.writeInt(this.z);
    }
}

