/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common.bases;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.server.v1_4_R1.ChunkCoordIntPair;
import org.bukkit.Chunk;
import org.bukkit.World;

public class IntVector2 {
    public final int x;
    public final int z;

    public IntVector2(Chunk chunk) {
        this(chunk.getX(), chunk.getZ());
    }

    public IntVector2(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public int hashCode() {
        long key = (long)this.x & 0xFFFFFFFFL | ((long)this.z & 0xFFFFFFFFL) << 32;
        return (int)key ^ (int)(key >> 32);
    }

    public ChunkCoordIntPair toPair() {
        return new ChunkCoordIntPair(this.x, this.z);
    }

    public Chunk toChunk(World world) {
        return world.getChunkAt(this.x, this.z);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof IntVector2) {
            IntVector2 vec = (IntVector2)object;
            return vec.x == this.x && vec.z == this.z;
        }
        return false;
    }

    public static IntVector2 read(DataInputStream stream) throws IOException {
        return new IntVector2(stream.readInt(), stream.readInt());
    }

    public void write(DataOutputStream stream) throws IOException {
        stream.writeInt(this.x);
        stream.writeInt(this.z);
    }
}

