/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common;

import com.bergerkiller.bukkit.common.config.ConfigurationNode;
import com.bergerkiller.bukkit.common.config.FileConfiguration;
import com.bergerkiller.bukkit.common.internal.CommonPlugin;
import com.bergerkiller.bukkit.common.localization.ILocalizationDefault;
import com.bergerkiller.bukkit.common.permissions.IPermissionDefault;
import com.bergerkiller.bukkit.common.permissions.NoPermissionException;
import com.bergerkiller.bukkit.common.reflection.classes.PluginDescriptionFileRef;
import com.bergerkiller.bukkit.common.utils.CommonUtil;
import com.bergerkiller.bukkit.common.utils.LogicUtil;
import com.bergerkiller.bukkit.common.utils.ParseUtil;
import com.bergerkiller.bukkit.common.utils.StringUtil;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class PluginBase
extends JavaPlugin {
    private String disableMessage = null;
    private FileConfiguration permissionconfig;
    private FileConfiguration localizationconfig;
    private boolean enabled = false;
    private boolean wasDisableRequested = false;

    public void log(Level level, String message) {
        Bukkit.getLogger().log(level, "[" + this.getName() + "] " + message);
    }

    public void logAction(CommandSender by, String action) {
        if (by instanceof Player) {
            this.log(Level.INFO, String.valueOf(((Player)by).getName()) + " " + action);
        }
    }

    public final String getVersion() {
        return this.getDescription().getVersion();
    }

    public int getVersionNumber() {
        String ver = this.getVersion();
        int dotIndex = ver.indexOf(46);
        if (dotIndex != -1 && (dotIndex = ver.indexOf(46, dotIndex + 1)) != -1) {
            ver = ver.substring(0, dotIndex);
        }
        return (int)(100.0 * ParseUtil.parseDouble(ver, 1.0));
    }

    public File getDataFile(String ... path) {
        if (path == null || path.length == 0) {
            return this.getDataFolder();
        }
        return new File(this.getDataFolder(), StringUtil.combine(File.separator, path));
    }

    public static Permission getPermission(String path) {
        Permission perm = Bukkit.getServer().getPluginManager().getPermission(path);
        if (perm == null) {
            perm = new Permission(path, PermissionDefault.FALSE);
            Bukkit.getServer().getPluginManager().addPermission(perm);
        }
        return perm;
    }

    public final ConfigurationNode getPermissionNode(String path) {
        return this.permissionconfig.getNode(path);
    }

    public final ConfigurationNode getLocalizationNode(String path) {
        return this.localizationconfig.getNode(path);
    }

    public final void register(String ... commands) {
        this.register((CommandExecutor)this, commands);
    }

    public final void register(CommandExecutor executor, String ... commands) {
        String[] stringArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            String command = stringArray[n2];
            PluginCommand cmd = this.getCommand(command);
            if (cmd != null) {
                cmd.setExecutor(executor);
            }
            ++n2;
        }
    }

    public final void register(Listener listener) {
        if (listener == null) {
            throw new RuntimeException("Can not load a listener: The listener instance is null");
        }
        if (listener != this) {
            Bukkit.getPluginManager().registerEvents(listener, (Plugin)this);
        }
    }

    public final void register(Class<? extends Listener> listener) {
        if (listener == null) {
            throw new RuntimeException("Can not load a listener: The listener class is null");
        }
        try {
            this.register(listener.newInstance());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void loadPermissions(Class<? extends IPermissionDefault> permissionDefaults) {
        IPermissionDefault[] iPermissionDefaultArray = CommonUtil.getClassConstants(permissionDefaults);
        int n = iPermissionDefaultArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPermissionDefault def = iPermissionDefaultArray[n2];
            this.loadPermission(def);
            ++n2;
        }
    }

    public final Permission loadPermission(IPermissionDefault permissionDefault) {
        return this.loadPermission(permissionDefault.getName(), permissionDefault.getDefault(), permissionDefault.getDescription());
    }

    public final Permission loadPermission(String path) {
        return this.loadPermission(PluginBase.getPermission(path));
    }

    public final Permission loadPermission(Permission permission) {
        return this.loadPermission(permission.getName(), permission.getDefault(), permission.getDescription());
    }

    public final Permission loadPermission(String path, PermissionDefault def, String description) {
        return this.loadPermission(this.getPermissionNode(path), def, description);
    }

    public final Permission loadPermission(ConfigurationNode node, PermissionDefault def, String description) {
        Permission permission = PluginBase.getPermission(node.getPath());
        permission.setDefault(node.get("default", def));
        permission.setDescription(node.get("description", description));
        return permission;
    }

    public void loadLocales(Class<? extends ILocalizationDefault> localizationDefaults) {
        ILocalizationDefault[] iLocalizationDefaultArray = CommonUtil.getClassConstants(localizationDefaults);
        int n = iLocalizationDefaultArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalizationDefault def = iLocalizationDefaultArray[n2];
            this.loadLocale(def);
            ++n2;
        }
    }

    public void loadLocale(ILocalizationDefault localizationDefault) {
        this.loadLocale(localizationDefault.getName(), localizationDefault.getDefault());
    }

    public void loadLocale(String path, String defaultValue) {
        if (!this.localizationconfig.contains(path = path.toLowerCase(Locale.ENGLISH))) {
            this.localizationconfig.set(path, defaultValue);
        }
    }

    private ConfigurationNode getCommandNode(String command) {
        String fullPath = "commands." + (command = command.toLowerCase(Locale.ENGLISH));
        if (this.localizationconfig.isNode(fullPath)) {
            return this.localizationconfig.getNode(fullPath);
        }
        fullPath = "commands." + command.replace('.', ' ');
        if (this.localizationconfig.isNode(fullPath)) {
            return this.localizationconfig.getNode(fullPath);
        }
        return null;
    }

    public String getCommandUsage(String command) {
        ConfigurationNode node = this.getCommandNode(command);
        String defValue = "/" + command;
        if (node == null) {
            return defValue;
        }
        return node.get("usage", defValue);
    }

    public String getCommandDescription(String command) {
        ConfigurationNode node = this.getCommandNode(command);
        String defValue = "No description specified";
        if (node == null) {
            return "No description specified";
        }
        return node.get("description", "No description specified");
    }

    public String getLocale(String path, String ... arguments) {
        if (this.localizationconfig.isNode(path = path.toLowerCase(Locale.ENGLISH))) {
            String newPath = String.valueOf(path) + ".default";
            if (arguments.length > 0) {
                StringBuilder tmpPathBuilder = new StringBuilder(path);
                String tmpPath = path;
                int i = 0;
                while (i < arguments.length) {
                    tmpPath = tmpPathBuilder.append('.').append(arguments[i].toLowerCase(Locale.ENGLISH)).toString();
                    if (!this.localizationconfig.contains(tmpPath)) break;
                    newPath = tmpPath;
                    ++i;
                }
            }
            path = newPath;
        }
        if (arguments.length > 0) {
            StringBuilder locale = new StringBuilder(this.localizationconfig.get(path, ""));
            int i = 0;
            while (i < arguments.length) {
                StringUtil.replaceAll(locale, "%" + i + "%", arguments[i]);
                ++i;
            }
            return locale.toString();
        }
        return this.localizationconfig.get(path, String.class, "");
    }

    public void permissions() {
    }

    public void localization() {
    }

    public final String getDisableMessage() {
        return this.disableMessage;
    }

    public void setDisableMessage(String msg) {
        this.disableMessage = msg;
    }

    public abstract int getMinimumLibVersion();

    public void handle(Throwable reason) {
        if (reason instanceof Exception) {
            reason.printStackTrace();
        } else if (reason instanceof OutOfMemoryError) {
            this.log(Level.SEVERE, "The server is running out of memory! Do something!");
        } else if (reason instanceof NoClassDefFoundError) {
            this.log(Level.WARNING, "Class is missing (plugin was hot-swapped?): " + reason.getMessage());
        } else {
            this.log(Level.SEVERE, "Encountered a critical error and had to be disabled.");
            this.log(Level.SEVERE, "You may have to update " + this.getName() + " or look for a newer CraftBukkit build.");
            reason.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
    }

    private static void setPermissions(ConfigurationNode node) {
        for (ConfigurationNode subNode : node.getNodes()) {
            PluginBase.setPermissions(subNode);
        }
        PermissionDefault def = (PermissionDefault)node.get("default", PermissionDefault.class);
        String desc = (String)((Object)node.get("description", String.class));
        if (def != null || desc != null) {
            Permission permission = PluginBase.getPermission(node.getPath().toLowerCase());
            if (def != null) {
                permission.setDefault(def);
            }
            if (desc != null) {
                permission.setDescription(desc);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void onEnable() {
        void var5_9;
        long startTime = System.currentTimeMillis();
        if (this.getMinimumLibVersion() > 148) {
            this.log(Level.SEVERE, "Requires a newer BKCommonLib version, please update BKCommonLib to the latest version!");
            this.log(Level.SEVERE, "Verify that there is only one BKCommonLib.jar in the plugins folder before retrying");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.setDisableMessage(String.valueOf(this.getName()) + " disabled!");
        this.permissionconfig = new FileConfiguration(this, "PermissionDefaults.yml");
        if (this.permissionconfig.exists()) {
            this.loadPermissions();
        }
        this.permissionconfig.setHeader("Below are the default permissions set for plugin '" + this.getName() + "'.");
        this.permissionconfig.addHeader("These permissions are ignored if the permission is set for a group or player.");
        this.permissionconfig.addHeader("Use the defaults as a base to keep the permissions file small");
        this.permissionconfig.addHeader("Need help with this file? Please visit:");
        this.permissionconfig.addHeader("http://dev.bukkit.org/server-mods/bkcommonlib/pages/permission-defaults/");
        this.localizationconfig = new FileConfiguration(this, "Localization.yml");
        if (this.localizationconfig.exists()) {
            this.loadLocalization();
        }
        this.localizationconfig.setHeader("Below are the localization nodes set for plugin '" + this.getName() + "'.");
        this.localizationconfig.addHeader("For colors, use the & character followed up by 0 - F");
        this.localizationconfig.addHeader("Need help with this file? Please visit:");
        this.localizationconfig.addHeader("http://dev.bukkit.org/server-mods/bkcommonlib/pages/localization/");
        HashMap commands = this.getDescription().getCommands();
        if (commands != null && PluginDescriptionFileRef.commands.isValid()) {
            ConfigurationNode commandsNode = this.getLocalizationNode("commands");
            commands = new HashMap(commands);
            for (Map.Entry entry : commands.entrySet()) {
                ConfigurationNode node = commandsNode.getNode((String)entry.getKey());
                HashMap<String, Object> data = new HashMap<String, Object>((Map)entry.getValue());
                node.shareWith(data, "description", "No description specified");
                node.shareWith(data, "usage", "/" + (String)entry.getKey());
                entry.setValue(Collections.unmodifiableMap(data));
            }
            PluginDescriptionFileRef.commands.set(this.getDescription(), Collections.unmodifiableMap(commands));
        }
        this.permissions();
        PluginBase.setPermissions(this.permissionconfig);
        if (!this.permissionconfig.isEmpty()) {
            this.savePermissions();
        }
        this.localization();
        if (!this.localizationconfig.isEmpty()) {
            this.saveLocalization();
        }
        try {
            this.wasDisableRequested = false;
            this.enable();
            if (this.wasDisableRequested) {
                return;
            }
            this.enabled = true;
        }
        catch (Throwable t) {
            this.log(Level.SEVERE, "An error occurred while enabling, the plugin will be disabled");
            this.log(Level.SEVERE, "You may have to update " + this.getName() + " or look for a newer CraftBukkit build.");
            t.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        CommonPlugin.getInstance().plugins.add(this);
        Plugin[] pluginArray = Bukkit.getPluginManager().getPlugins();
        int n = pluginArray.length;
        boolean n2 = false;
        while (var5_9 < n) {
            Plugin plugin = pluginArray[var5_9];
            if (plugin.isEnabled()) {
                this.updateDependency(plugin, plugin.getName(), true);
            }
            ++var5_9;
        }
        Bukkit.getLogger().log(Level.INFO, String.valueOf(this.getName()) + " version " + this.getVersion() + " enabled! (" + 0.001 * (double)(System.currentTimeMillis() - startTime) + "s)");
    }

    public final void onDisable() {
        boolean doDisableMessage;
        Plugin[] pluginArray = Bukkit.getServer().getPluginManager().getPlugins();
        int n = pluginArray.length;
        int n2 = 0;
        while (n2 < n) {
            List depend;
            Plugin plugin = pluginArray[n2];
            if (plugin.isEnabled() && (depend = plugin.getDescription().getDepend()) != null && depend.contains(this.getName())) {
                Bukkit.getServer().getPluginManager().disablePlugin(plugin);
            }
            ++n2;
        }
        this.wasDisableRequested = true;
        boolean bl = doDisableMessage = this.disableMessage != null;
        if (this.enabled) {
            try {
                this.disable();
            }
            catch (Throwable t) {
                this.log(Level.SEVERE, "An error occurred while disabling:");
                t.printStackTrace();
                doDisableMessage = false;
            }
            this.enabled = false;
            if (CommonPlugin.getInstance() != null) {
                CommonPlugin.getInstance().plugins.remove((Object)this);
            }
        }
        if (doDisableMessage) {
            Bukkit.getLogger().log(Level.INFO, this.disableMessage);
        }
    }

    public final boolean onCommand(CommandSender sender, Command cmd, String command, String[] args) {
        block7: {
            String[] fixedArgs = StringUtil.convertArgs(args);
            if (fixedArgs.length >= 1 && LogicUtil.contains(fixedArgs[0].toLowerCase(Locale.ENGLISH), "version", "ver")) {
                sender.sendMessage(ChatColor.GREEN + this.getName() + " v" + this.getVersion() + " using BKCommonLib v" + CommonPlugin.getInstance().getVersion());
            }
            if (!this.command(sender, command, fixedArgs)) break block7;
            return true;
        }
        try {
            sender.sendMessage(ChatColor.RED + "Unknown command, for help use /help " + command);
        }
        catch (NoPermissionException ex) {
            if (sender instanceof Player) {
                sender.sendMessage(ChatColor.RED + "You do not have permission to use this command!");
            } else {
                sender.sendMessage("This command is only for players!");
            }
        }
        catch (Throwable t) {
            StringBuilder msg = new StringBuilder("Unhandled exception executing command '");
            msg.append(command).append("' in plugin ").append(this.getName()).append(" v").append(this.getVersion());
            Bukkit.getLogger().log(Level.SEVERE, msg.toString());
            t.printStackTrace();
            sender.sendMessage(ChatColor.RED + "An internal error occured while executing this command");
        }
        return true;
    }

    public abstract void enable();

    public abstract void disable();

    public abstract boolean command(CommandSender var1, String var2, String[] var3);

    public final void loadLocalization() {
        this.localizationconfig.load();
    }

    public final void saveLocalization() {
        this.localizationconfig.save();
    }

    public final void loadPermissions() {
        this.permissionconfig.load();
    }

    public final void savePermissions() {
        this.permissionconfig.save();
    }

    public void updateDependency(Plugin plugin, String pluginName, boolean enabled) {
    }
}

