/*
 * Decompiled with CFR 0.152.
 */
package com.bergerkiller.bukkit.common;

import com.bergerkiller.bukkit.common.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class MessageBuilder {
    private final List<StringBuilder> lines = new ArrayList<StringBuilder>();
    private StringBuilder builder;
    private int currentWidth;
    private String separator = null;
    private int sepwidth = 0;
    private int indent = 0;
    public static final int CHAT_WINDOW_WIDTH = 240;

    public MessageBuilder() {
        this(new StringBuilder());
    }

    public MessageBuilder(String firstLine) {
        this(new StringBuilder(firstLine));
    }

    public MessageBuilder(int capacity) {
        this(new StringBuilder(capacity));
    }

    public MessageBuilder(StringBuilder builder) {
        this.builder = builder;
        this.lines.add(this.builder);
        this.currentWidth = 0;
    }

    public MessageBuilder setSeparator(ChatColor color, String separator) {
        return this.setSeparator(color + separator);
    }

    public MessageBuilder setSeparator(String separator) {
        if (separator == null) {
            return this.clearSeparator();
        }
        this.separator = separator;
        this.sepwidth = StringUtil.getWidth(separator);
        return this;
    }

    public MessageBuilder clearSeparator() {
        this.separator = null;
        this.sepwidth = 0;
        return this;
    }

    public int getIndent() {
        return this.indent;
    }

    public MessageBuilder indent(int indent) {
        this.indent += indent;
        return this;
    }

    public MessageBuilder setIndent(int indent) {
        this.indent = indent;
        return this;
    }

    public MessageBuilder wordWrap(String ... toAppend) {
        if (this.needsWordWrap(toAppend)) {
            this.newLine();
        }
        return this;
    }

    public boolean needsWordWrap(String ... textToAppend) {
        return this.needsWordWrap(StringUtil.getWidth(textToAppend));
    }

    public boolean needsWordWrap(int widthToAppend) {
        return this.currentWidth + widthToAppend + this.sepwidth + this.indent * StringUtil.SPACE_WIDTH > 240;
    }

    public MessageBuilder black(Object ... text) {
        return this.append(ChatColor.BLACK, text);
    }

    public MessageBuilder dark_blue(Object ... text) {
        return this.append(ChatColor.DARK_BLUE, text);
    }

    public MessageBuilder dark_green(Object ... text) {
        return this.append(ChatColor.DARK_GREEN, text);
    }

    public MessageBuilder dark_aqua(Object ... text) {
        return this.append(ChatColor.DARK_AQUA, text);
    }

    public MessageBuilder dark_red(Object ... text) {
        return this.append(ChatColor.DARK_RED, text);
    }

    public MessageBuilder dark_purple(Object ... text) {
        return this.append(ChatColor.DARK_PURPLE, text);
    }

    public MessageBuilder gold(Object ... text) {
        return this.append(ChatColor.GOLD, text);
    }

    public MessageBuilder gray(Object ... text) {
        return this.append(ChatColor.GRAY, text);
    }

    public MessageBuilder dark_gray(Object ... text) {
        return this.append(ChatColor.DARK_GRAY, text);
    }

    public MessageBuilder blue(Object ... text) {
        return this.append(ChatColor.BLUE, text);
    }

    public MessageBuilder green(Object ... text) {
        return this.append(ChatColor.GREEN, text);
    }

    public MessageBuilder aqua(Object ... text) {
        return this.append(ChatColor.AQUA, text);
    }

    public MessageBuilder red(Object ... text) {
        return this.append(ChatColor.RED, text);
    }

    public MessageBuilder light_purple(Object ... text) {
        return this.append(ChatColor.LIGHT_PURPLE, text);
    }

    public MessageBuilder yellow(Object ... text) {
        return this.append(ChatColor.YELLOW, text);
    }

    public MessageBuilder white(Object ... text) {
        return this.append(ChatColor.WHITE, text);
    }

    public MessageBuilder magic(Object ... text) {
        return this.append(ChatColor.MAGIC, text);
    }

    public MessageBuilder append(ChatColor color, Object ... text) {
        String[] newtext = new String[text.length];
        int i = 0;
        while (i < text.length) {
            newtext[i] = text[i].toString();
            ++i;
        }
        return this.append(color, newtext);
    }

    public MessageBuilder append(Object ... text) {
        String[] newtext = new String[text.length];
        int i = 0;
        while (i < text.length) {
            newtext[i] = text[i].toString();
            ++i;
        }
        return this.append(newtext);
    }

    public MessageBuilder append(ChatColor color, String ... text) {
        if (text != null && text.length > 0) {
            int width = StringUtil.getWidth(text);
            if (this.needsWordWrap(width)) {
                this.newLine();
            }
            this.currentWidth += width;
            this.prepareNewAppend();
            this.builder.append(color.toString());
            String[] stringArray = text;
            int n = text.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                this.builder.append(part);
                ++n2;
            }
        }
        return this;
    }

    public MessageBuilder append(char character) {
        if (character == '\n') {
            return this.newLine();
        }
        int width = StringUtil.getWidth(character);
        if (this.needsWordWrap(width)) {
            this.newLine();
        }
        this.currentWidth += width;
        this.prepareNewAppend();
        this.builder.append(character);
        return this;
    }

    public MessageBuilder append(String ... text) {
        if (text != null && text.length > 0) {
            int width = StringUtil.getWidth(text);
            if (this.needsWordWrap(width)) {
                this.newLine();
            }
            this.currentWidth += width;
            this.prepareNewAppend();
            String[] stringArray = text;
            int n = text.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                this.builder.append(part);
                ++n2;
            }
        }
        return this;
    }

    private void prepareNewAppend() {
        if (this.builder.length() == 0) {
            this.currentWidth += StringUtil.SPACE_WIDTH * this.indent;
            int i = 0;
            while (i < this.indent) {
                this.builder.append(' ');
                ++i;
            }
        } else if (this.separator != null) {
            this.currentWidth += this.sepwidth;
            this.builder.append(this.separator);
        }
    }

    public MessageBuilder newLine() {
        this.builder = new StringBuilder();
        this.lines.add(this.builder);
        this.currentWidth = 0;
        return this;
    }

    public int length() {
        int length = this.lines.size() - 1;
        for (StringBuilder line : this.lines) {
            length += line.length();
        }
        return length;
    }

    public boolean isEmpty() {
        return this.lines.size() == 1 && this.builder.length() == 0;
    }

    public String lastLine() {
        return this.builder.toString();
    }

    public String toString() {
        StringBuilder total = new StringBuilder(this.length());
        int i = 0;
        while (i < this.lines.size()) {
            if (i != 0) {
                total.append('\n');
            }
            total.append((CharSequence)this.lines.get(i));
            ++i;
        }
        return total.toString();
    }

    public String[] lines() {
        if (this.isEmpty()) {
            return new String[0];
        }
        String[] lines = new String[this.lines.size()];
        int i = 0;
        for (StringBuilder line : this.lines) {
            lines[i++] = line.toString();
        }
        return lines;
    }

    public MessageBuilder clear() {
        this.lines.clear();
        this.builder = new StringBuilder();
        this.lines.add(this.builder);
        this.currentWidth = 0;
        return this;
    }

    public MessageBuilder flush(CommandSender sender) {
        return this.send(sender).clear();
    }

    public MessageBuilder send(CommandSender sender) {
        for (StringBuilder line : this.lines) {
            sender.sendMessage(line.toString());
        }
        return this;
    }

    public MessageBuilder log(Level level) {
        for (StringBuilder line : this.lines) {
            Bukkit.getLogger().log(level, line.toString());
        }
        return this;
    }
}

